/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.guis.ContainerInfChest;
import com.kotori316.infchest.common.tiles.HasInv;
import com.kotori316.infchest.common.tiles.IRunUpdates;
import com.kotori316.infchest.common.tiles.InsertingHook;
import com.kotori316.infchest.common.tiles.TileUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileInfChest
extends BlockEntity
implements HasInv,
IRunUpdates,
MenuProvider,
Nameable {
    protected ItemStack holding = ItemStack.EMPTY;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    @NotNull
    private BigInteger count = BigInteger.ZERO;
    @Nullable
    private Component customName;
    public static final String NBT_ITEM = "item";
    public static final String NBT_COUNT = "count";
    private static final String NBT_CUSTOM_NAME = "custom_name";
    public static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private final List<Runnable> updateRunnable = new ArrayList<Runnable>();
    private final InsertingHook hook = InsertingHook.getInstance();
    public static final String GUI_ID = "infchest:gui_infchest";

    public TileInfChest(BlockPos pos, BlockState state) {
        super(InfChest.accessor.INF_CHEST_TYPE(), pos, state);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        valueOutput.putString(NBT_COUNT, this.count.toString());
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.inventory);
        valueOutput.store(NBT_ITEM, ItemStack.OPTIONAL_CODEC, (Object)this.holding);
        valueOutput.storeNullable(NBT_CUSTOM_NAME, ComponentSerialization.CODEC, (Object)this.customName);
        super.saveAdditional(valueOutput);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.holding = valueInput.read(NBT_ITEM, ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        try {
            this.count = valueInput.getString(NBT_COUNT).map(BigDecimal::new).map(BigDecimal::toBigIntegerExact).orElse(BigInteger.ZERO);
        }
        catch (ArithmeticException | NumberFormatException e) {
            InfChest.LOGGER.error("TileInfChest loading problem.", (Throwable)e);
            this.count = BigInteger.ZERO;
        }
        this.customName = valueInput.read(NBT_CUSTOM_NAME, ComponentSerialization.CODEC).orElse(null);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.inventory);
        this.updateInv();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    @NotNull
    public Component getName() {
        if (this.customName != null) {
            return this.customName;
        }
        return Component.translatable((String)InfChest.accessor.CHEST().getDescriptionId());
    }

    public void setCustomName(@Nullable Component name) {
        this.customName = name;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty) && this.holding.isEmpty();
    }

    @Override
    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        ItemStack s = ContainerHelper.removeItem(this.inventory, (int)index, (int)count);
        if (index == 1) {
            if (this.level != null && !this.level.isClientSide) {
                this.decrStack(BigInteger.valueOf(s.getCount()));
            }
            this.setChanged();
        }
        return s;
    }

    @Override
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack s = ContainerHelper.takeItem(this.inventory, (int)index);
        if (index == 1) {
            if (this.level != null && !this.level.isClientSide) {
                this.decrStack(BigInteger.valueOf(s.getCount()));
            }
            this.setChanged();
        }
        return s;
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        ItemStack before = (ItemStack)this.inventory.set(index, (Object)stack);
        if (index == 1 && this.level != null && !this.level.isClientSide) {
            if (!stack.isEmpty() && TileInfChest.stacksEqual(this.holding, stack)) {
                this.count = this.count.add(BigInteger.valueOf(stack.getCount()));
            }
            this.decrStack(BigInteger.valueOf(before.getCount()));
        }
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        this.updateInv();
    }

    @Override
    public void startOpen(Player player) {
        if (this.level != null && !this.level.isClientSide) {
            this.runUpdates();
        }
    }

    public void updateInv() {
        ItemStack insert = this.getItem(0);
        if (!insert.isEmpty() && this.canPlaceItem(0, insert)) {
            this.addStack(insert);
        }
        if (this.holding.isEmpty()) {
            this.inventory.set(1, (Object)ItemStack.EMPTY);
        } else {
            ItemStack out = this.getItem(1);
            if (out.isEmpty() || TileInfChest.stacksEqual(this.holding, out)) {
                int expectedCount = this.totalCount().min(BigInteger.valueOf(this.holding.getMaxStackSize())).intValueExact();
                this.inventory.set(1, (Object)TileInfChest.copyAmount(this.holding, expectedCount));
            }
        }
        if (this.level != null && !this.level.isClientSide) {
            this.runUpdates();
        }
    }

    protected void addStack(ItemStack insert) {
        this.addStack(insert, BigInteger.valueOf(insert.getCount()));
    }

    public void addStack(ItemStack insert, BigInteger add) {
        Optional<InsertingHook.Hook> hookObject = this.hook.findHookObject(insert);
        if (hookObject.isPresent()) {
            hookObject.ifPresent(h -> {
                this.count = this.count.add(h.getCount(insert));
                this.inventory.set(0, (Object)h.removeAllItems(insert));
            });
        } else {
            this.count = this.count.add(add);
            if (this.holding.isEmpty()) {
                this.holding = TileInfChest.copyAmount(insert, 1);
            }
            this.inventory.set(0, (Object)ItemStack.EMPTY);
        }
    }

    public void decrStack(BigInteger subs) {
        if (subs.compareTo(this.count) > 0) {
            throw new IllegalArgumentException("subs > count");
        }
        this.count = this.count.subtract(subs);
        if (this.count.equals(BigInteger.ZERO)) {
            this.holding = ItemStack.EMPTY;
        }
    }

    public ItemStack getHolding() {
        if (!this.holding.isEmpty()) {
            return TileInfChest.copyAmount(this.holding, INT_MAX.min(this.totalCount()).intValueExact());
        }
        ItemStack out = this.getItem(1);
        if (!out.isEmpty()) {
            return out.copy();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getHoldingWithOneCount() {
        if (!this.holding.isEmpty()) {
            return TileInfChest.copyAmount(this.holding, 1);
        }
        ItemStack out = this.getItem(1);
        if (!out.isEmpty()) {
            return TileInfChest.copyAmount(out, 1);
        }
        return ItemStack.EMPTY;
    }

    public BigInteger totalCount() {
        return this.count;
    }

    public void setCount(@NotNull BigInteger count) {
        this.count = count;
    }

    public void setHolding(ItemStack holding) {
        this.holding = holding;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.level != null && this.level.getBlockEntity(this.getBlockPos()) == this && player.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) <= 64.0;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 0) {
            Optional<InsertingHook.Hook> hookObject = this.hook.findHookObject(stack);
            ItemStack secondStack = this.getItem(1);
            return this.holding.isEmpty() && hookObject.isEmpty() && (secondStack.isEmpty() || TileInfChest.stacksEqual(secondStack, stack)) || TileInfChest.stacksEqual(this.holding, stack) || hookObject.filter(h -> h.checkItemAcceptable(this.holding, stack, TileUtil.providerFromEntity(this))).isPresent();
        }
        return false;
    }

    public boolean canInsertFromOutside(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!this.getItem(0).isEmpty()) {
            return false;
        }
        if (this.holding.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)this.holding, (ItemStack)stack);
    }

    @Override
    public void clearContent() {
        this.inventory.clear();
        this.holding = ItemStack.EMPTY;
        this.count = BigInteger.ZERO;
    }

    private static ItemStack copyAmount(ItemStack stack, int amount) {
        ItemStack copy = stack.copy();
        copy.setCount(amount);
        return copy;
    }

    private static boolean stacksEqual(ItemStack s1, ItemStack s2) {
        return ItemStack.isSameItemSameComponents((ItemStack)s1, (ItemStack)s2);
    }

    private static boolean gt(BigInteger bigInteger, int i) {
        return bigInteger.compareTo(BigInteger.valueOf(i)) > 0;
    }

    @Override
    public void addUpdate(Runnable runnable) {
        this.updateRunnable.add(runnable);
    }

    public List<Runnable> getUpdates() {
        return this.updateRunnable;
    }

    @Override
    public void runUpdateRemoveIf(Predicate<Runnable> predicate) {
        this.updateRunnable.removeIf(predicate);
    }

    public AbstractContainerMenu createMenu(int containerID, Inventory inventory, Player player) {
        return new ContainerInfChest(containerID, inventory, this.getBlockPos());
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
    }
}

