/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public final class TileUtil {
    public static TagValueOutput saveWithoutMetadata(BlockEntity entity) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)TileUtil.providerFromEntity(entity));
        entity.saveWithoutMetadata((ValueOutput)output);
        return output;
    }

    public static HolderLookup.Provider providerFromEntity(BlockEntity entity) {
        Level level = entity.getLevel();
        if (level == null) {
            throw new IllegalStateException("Level in entity cannot be null!");
        }
        return level.registryAccess();
    }

    public static ItemStack parseItemStack(BlockEntity entity, CompoundTag tag) {
        RegistryOps ops = TileUtil.providerFromEntity(entity).createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)tag).result().orElse(ItemStack.EMPTY);
    }

    public static Tag serializeItemStack(BlockEntity entity, ItemStack stack) {
        RegistryOps ops = TileUtil.providerFromEntity(entity).createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)stack).result().orElseThrow(() -> new IllegalStateException("Failed to serialize ItemStack: " + String.valueOf(stack)));
    }
}

