/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.forge.tiles;

import com.kotori316.infchest.forge.tiles.TileInfChestForge;
import java.math.BigInteger;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

record InfItemHandler(TileInfChestForge infChest) implements IItemHandler
{
    public int getSlots() {
        return 2;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 1) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.infChest.getHolding();
        stack.setCount(Math.min(stack.getCount(), stack.getMaxStackSize()));
        return stack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.infChest.addStack(stack);
            this.infChest.setChanged();
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 1) {
            return ItemStack.EMPTY;
        }
        ItemStack item = this.infChest.getHolding();
        if (item.isEmpty()) {
            return ItemStack.EMPTY;
        }
        BigInteger extractCount = this.infChest.totalCount().min(BigInteger.valueOf(amount));
        if (!simulate) {
            this.infChest.decrStack(extractCount);
            this.infChest.setChanged();
        }
        item.setCount(extractCount.intValueExact());
        return item;
    }

    public int getSlotLimit(int slot) {
        return this.infChest.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot != 0) {
            return false;
        }
        return this.infChest.canInsertFromOutside(stack);
    }
}

