/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.guis;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.tiles.TileInfChest;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerInfChest
extends AbstractContainerMenu {
    final TileInfChest infChest;

    public ContainerInfChest(int id, Inventory playerInventory, BlockPos pos) {
        super(InfChest.accessor.INF_CHEST_CONTAINER_TYPE(), id);
        this.infChest = (TileInfChest)playerInventory.player.level().getBlockEntity(pos);
        if (this.infChest != null) {
            this.infChest.startOpen(playerInventory.player);
        }
        int oneBox = 18;
        this.addSlot(new LimitSlot(this.infChest, 0, 31, 35));
        this.addSlot(new LimitSlot(this.infChest, 1, 127, 35));
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)playerInventory, 9 + h * 9 + v, 8 + oneBox * v, 84 + oneBox * h));
            }
        }
        for (int v = 0; v < 9; ++v) {
            this.addSlot(new Slot((Container)playerInventory, v, 8 + oneBox * v, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.infChest.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot from = this.getSlot(index);
        if (from.hasItem()) {
            ItemStack current = from.getItem().copy();
            int originalSize = current.getCount();
            int originalSlot = 2;
            if (index < originalSlot ? !this.moveItemStackTo(current, originalSlot, originalSlot + 36, true) : this.infChest.canPlaceItem(0, current) && !this.moveItemStackTo(current, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (current.getCount() == 0) {
                from.set(ItemStack.EMPTY);
            } else {
                from.setChanged();
            }
            if (current.getCount() == originalSize) {
                return ItemStack.EMPTY;
            }
            from.onTake(playerIn, current);
        }
        return ItemStack.EMPTY;
    }

    public static ContainerInfChest create(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerInfChest(windowId, inv, data.readBlockPos());
    }

    public static ContainerInfChest createFabric(int windowId, Inventory inv, BlockPos pos) {
        return new ContainerInfChest(windowId, inv, pos);
    }

    private static class LimitSlot
    extends Slot {
        LimitSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return this.container.canPlaceItem(this.index, stack);
        }
    }
}

