/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.guis;

import com.kotori316.infchest.common.guis.ContainerInfChest;
import com.kotori316.infchest.common.tiles.TileInfChest;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class GuiInfChest
extends AbstractContainerScreen<ContainerInfChest> {
    private final TileInfChest infChest;
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"infchest", (String)"textures/gui/infchest.png");

    public GuiInfChest(ContainerInfChest container, Inventory inventory, Component component) {
        super((AbstractContainerMenu)container, inventory, component);
        this.infChest = container.infChest;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        Optional.ofNullable(this.infChest).map(TileInfChest::getHolding).filter(Predicate.not(ItemStack::isEmpty)).map(ItemStack::getDisplayName).ifPresent(itemName -> {
            graphics.drawString(this.font, itemName, (this.imageWidth - this.font.width((FormattedText)itemName)) / 2, 20, ARGB.opaque((int)0x404040), false);
            graphics.drawString(this.font, "Item: " + String.valueOf(this.infChest.totalCount()), 8, 60, ARGB.opaque((int)0x404040), false);
        });
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

