/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.integration;

import com.kotori316.infchest.common.tiles.TileInfChest;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public final class CommonAE2Part {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(9000000000000000000L);

    public static long insert(TileInfChest chest, long amount, ItemStack definition, boolean execute) {
        if (!chest.canInsertFromOutside(definition)) {
            return 0L;
        }
        if (execute) {
            chest.addStack(definition, BigInteger.valueOf(amount));
            chest.setChanged();
        }
        return amount;
    }

    public static long extract(TileInfChest chest, long amount, ItemStack definition, boolean execute) {
        ItemStack holding = chest.getHolding();
        ItemStack out = chest.getItem(1);
        if (ItemStack.isSameItemSameComponents((ItemStack)definition, (ItemStack)holding)) {
            BigInteger extractCount = BigInteger.valueOf(amount).min(chest.totalCount());
            if (execute) {
                chest.decrStack(extractCount);
                chest.setChanged();
            }
            return extractCount.longValue();
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)definition, (ItemStack)out)) {
            int extractCount = (int)Math.min((long)out.getCount(), amount);
            if (execute) {
                chest.removeItem(1, extractCount);
                chest.setChanged();
            }
            return extractCount;
        }
        return 0L;
    }

    public static <Key> void getAvailableStacks(Function<ItemStack, Key> keyFactory, BiConsumer<Key, Long> out, TileInfChest chest) {
        ItemStack holding = chest.getHolding();
        if (!holding.isEmpty()) {
            BigInteger count = LONG_MAX.min(chest.totalCount());
            out.accept(Objects.requireNonNull(keyFactory.apply(holding)), count.longValue());
        }
    }

    public static boolean isPreferredStorageFor(TileInfChest chest, ItemStack toInsert) {
        return chest.canInsertFromOutside(toInsert);
    }
}

