/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.kotori316.infchest.common.InfChest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;

public record InsertingHook(List<Hook> hooks) {
    private static final List<Hook> DEFAULT_HOOKS;

    public static InsertingHook getInstance() {
        return new InsertingHook(DEFAULT_HOOKS);
    }

    public Optional<Hook> findHookObject(ItemStack maybeHookItem) {
        return this.hooks.stream().filter(h -> h.isHookItem(maybeHookItem)).findFirst();
    }

    static {
        ArrayList<InfChestHook> list = new ArrayList<InfChestHook>();
        list.add(new InfChestHook());
        DEFAULT_HOOKS = Collections.unmodifiableList(list);
    }

    public static interface Hook {
        public boolean isHookItem(ItemStack var1);

        public BigInteger getCount(ItemStack var1);

        public ItemStack removeAllItems(ItemStack var1);

        public boolean checkItemAcceptable(ItemStack var1, ItemStack var2, HolderLookup.Provider var3);
    }

    private static final class InfChestHook
    implements Hook {
        private InfChestHook() {
        }

        @Override
        public boolean isHookItem(ItemStack stack) {
            return stack.getItem() == InfChest.accessor.CHEST().itemBlock;
        }

        @Override
        public BigInteger getCount(ItemStack hookItem) {
            CustomData tag = (CustomData)hookItem.get(DataComponents.BLOCK_ENTITY_DATA);
            if (tag == null) {
                return BigInteger.ZERO;
            }
            try {
                return tag.copyTag().getString("count").map(BigDecimal::new).map(BigDecimal::toBigIntegerExact).map(i -> i.multiply(BigInteger.valueOf(Math.max(hookItem.getCount(), 1)))).orElse(BigInteger.ZERO);
            }
            catch (ArithmeticException | NumberFormatException e) {
                InfChest.LOGGER.error("Invalid item count.", (Throwable)e);
                return BigInteger.ZERO;
            }
        }

        @Override
        public ItemStack removeAllItems(ItemStack hookItem) {
            BlockItem.setBlockEntityData((ItemStack)hookItem, InfChest.accessor.INF_CHEST_TYPE(), (TagValueOutput)TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING));
            return hookItem;
        }

        @Override
        public boolean checkItemAcceptable(ItemStack chestContent, ItemStack hookItem, HolderLookup.Provider provider) {
            CustomData tag = (CustomData)hookItem.get(DataComponents.BLOCK_ENTITY_DATA);
            if (tag == null) {
                return false;
            }
            ItemStack holding = tag.copyTag().read("item", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            return ItemStack.isSameItemSameComponents((ItemStack)chestContent, (ItemStack)holding);
        }

        private static ItemStack getSecondItem(ValueInput input) {
            NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)list);
            return (ItemStack)list.get(1);
        }
    }
}

