/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.forge.integration;

import com.kotori316.infchest.common.integration.CommonAE2Part;
import com.kotori316.infchest.common.tiles.TileInfChest;
import com.kotori316.infchest.forge.integration.RsInfChestIntegration;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.refinedmods.refinedstorage.api.util.Action;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

record RsInfChestInv(TileInfChest chest, IExternalStorageContext context, AtomicReference<ItemStack> cache) implements IExternalStorage<ItemStack>
{
    public void update(INetwork network) {
        if (this.getAccessType() != AccessType.INSERT) {
            ItemStack cached = this.cache.get();
            if (cached == null) {
                ItemStack holding = this.chest.getHolding();
                this.cache.set(holding);
                return;
            }
            ItemStack holding = this.chest.getHolding();
            if (!ItemStack.matches((ItemStack)cached, (ItemStack)holding)) {
                if (!cached.isEmpty() && ItemHandlerHelper.canItemStacksStack((ItemStack)cached, (ItemStack)holding)) {
                    int delta = holding.getCount() - cached.getCount();
                    if (delta > 0) {
                        network.getItemStorageCache().add((Object)cached, Math.abs(delta), false, true);
                    } else {
                        network.getItemStorageCache().remove((Object)cached, Math.abs(delta), true);
                    }
                    this.cache.set(holding);
                } else {
                    if (!cached.isEmpty()) {
                        network.getItemStorageCache().remove((Object)cached, cached.getCount(), true);
                    }
                    if (!holding.isEmpty()) {
                        network.getItemStorageCache().add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)holding, (int)1), holding.getCount(), false, true);
                        this.cache.set(holding);
                    } else {
                        this.cache.set(ItemStack.EMPTY);
                    }
                }
                network.getItemStorageCache().flush();
            }
        }
    }

    public long getCapacity() {
        return Integer.MAX_VALUE;
    }

    public Collection<ItemStack> getStacks() {
        return Collections.singleton(this.chest.getHolding());
    }

    @NotNull
    public ItemStack insert(@NotNull ItemStack stack, int size, Action action) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int inserted = (int)CommonAE2Part.insert(this.chest, size, stack, action == Action.PERFORM);
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - inserted));
    }

    @NotNull
    public ItemStack extract(@NotNull ItemStack stack, int size, int flags, Action action) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack holding = this.chest.getHolding();
        if (!RsInfChestIntegration.RsAccess.RS_API.getComparer().isEqual(stack, holding, flags)) {
            return ItemStack.EMPTY;
        }
        int extracted = (int)CommonAE2Part.extract(this.chest, size, stack, action == Action.PERFORM);
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)extracted);
    }

    public int getStored() {
        return TileInfChest.INT_MAX.min(this.chest.totalCount()).intValueExact();
    }

    public int getPriority() {
        return this.context.getPriority();
    }

    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.getCount();
    }
}

