/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.forge.tiles;

import com.kotori316.infchest.forge.tiles.TileDequeForge;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

record DequeItemHandler(TileDequeForge deque) implements IItemHandlerModifiable
{
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.deque.setItem(slot, stack);
    }

    public int getSlots() {
        return this.deque.getContainerSize();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.deque.getItem(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.getSlots() < 1000000) {
            if (!simulate) {
                this.deque.getInventory().add(stack.copy());
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            ItemStack peek = this.deque.getInventory().peek();
            if (peek == null) {
                return ItemStack.EMPTY;
            }
            if (peek.getCount() <= amount) {
                if (!simulate) {
                    this.deque.getInventory().removeFirst();
                }
                return peek.copy();
            }
            if (!simulate) {
                return peek.split(amount);
            }
            ItemStack t = peek.copy();
            t.setCount(amount);
            return t;
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.deque.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

