/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.kotori316.infchest.common.InfChest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11580;
import net.minecraft.class_1262;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9334;

public record InsertingHook(List<Hook> hooks) {
    private static final List<Hook> DEFAULT_HOOKS;

    public static InsertingHook getInstance() {
        return new InsertingHook(DEFAULT_HOOKS);
    }

    public Optional<Hook> findHookObject(class_1799 maybeHookItem) {
        return this.hooks.stream().filter(h -> h.isHookItem(maybeHookItem)).findFirst();
    }

    static {
        ArrayList<InfChestHook> list = new ArrayList<InfChestHook>();
        list.add(new InfChestHook());
        DEFAULT_HOOKS = Collections.unmodifiableList(list);
    }

    public static interface Hook {
        public boolean isHookItem(class_1799 var1);

        public BigInteger getCount(class_1799 var1);

        public class_1799 removeAllItems(class_1799 var1);

        public boolean checkItemAcceptable(class_1799 var1, class_1799 var2, class_7225.class_7874 var3);
    }

    private static final class InfChestHook
    implements Hook {
        private InfChestHook() {
        }

        @Override
        public boolean isHookItem(class_1799 stack) {
            return stack.method_7909() == InfChest.accessor.CHEST().itemBlock;
        }

        @Override
        public BigInteger getCount(class_1799 hookItem) {
            class_11580 tag = (class_11580)hookItem.method_58694(class_9334.field_49611);
            if (tag == null) {
                return BigInteger.ZERO;
            }
            try {
                return tag.method_72540().method_10558("count").map(BigDecimal::new).map(BigDecimal::toBigIntegerExact).map(i -> i.multiply(BigInteger.valueOf(Math.max(hookItem.method_7947(), 1)))).orElse(BigInteger.ZERO);
            }
            catch (ArithmeticException | NumberFormatException e) {
                InfChest.LOGGER.error("Invalid item count.", (Throwable)e);
                return BigInteger.ZERO;
            }
        }

        @Override
        public class_1799 removeAllItems(class_1799 hookItem) {
            class_1747.method_57338((class_1799)hookItem, InfChest.accessor.INF_CHEST_TYPE(), (class_11362)class_11362.method_71458((class_8942)class_8942.field_60348));
            return hookItem;
        }

        @Override
        public boolean checkItemAcceptable(class_1799 chestContent, class_1799 hookItem, class_7225.class_7874 provider) {
            class_11580 tag = (class_11580)hookItem.method_58694(class_9334.field_49611);
            if (tag == null) {
                return false;
            }
            class_1799 holding = tag.method_72540().method_67491("item", class_1799.field_49266).orElse(class_1799.field_8037);
            return class_1799.method_31577((class_1799)chestContent, (class_1799)holding);
        }

        private static class_1799 getSecondItem(class_11368 input) {
            class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
            class_1262.method_5429((class_11368)input, (class_2371)list);
            return (class_1799)list.get(1);
        }
    }
}

