/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.guis.ContainerInfChest;
import com.kotori316.infchest.common.tiles.HasInv;
import com.kotori316.infchest.common.tiles.IRunUpdates;
import com.kotori316.infchest.common.tiles.InsertingHook;
import com.kotori316.infchest.common.tiles.TileUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11565;
import net.minecraft.class_1262;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileInfChest
extends class_2586
implements HasInv,
IRunUpdates,
class_3908,
class_1275 {
    protected class_1799 holding = class_1799.field_8037;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    @NotNull
    private BigInteger count = BigInteger.ZERO;
    @Nullable
    private class_2561 customName;
    public static final String NBT_ITEM = "item";
    public static final String NBT_COUNT = "count";
    private static final String NBT_CUSTOM_NAME = "custom_name";
    public static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private final List<Runnable> updateRunnable = new ArrayList<Runnable>();
    private final InsertingHook hook = InsertingHook.getInstance();
    public static final String GUI_ID = "infchest:gui_infchest";

    public TileInfChest(class_2338 pos, class_2680 state) {
        super(InfChest.accessor.INF_CHEST_TYPE(), pos, state);
    }

    protected void method_11007(class_11372 valueOutput) {
        valueOutput.method_71469(NBT_COUNT, this.count.toString());
        class_1262.method_5426((class_11372)valueOutput, this.inventory);
        valueOutput.method_71468(NBT_ITEM, class_1799.field_49266, (Object)this.holding);
        valueOutput.method_71477(NBT_CUSTOM_NAME, class_8824.field_46597, (Object)this.customName);
        super.method_11007(valueOutput);
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.holding = valueInput.method_71426(NBT_ITEM, class_1799.field_49266).orElse(class_1799.field_8037);
        try {
            this.count = valueInput.method_71441(NBT_COUNT).map(BigDecimal::new).map(BigDecimal::toBigIntegerExact).orElse(BigInteger.ZERO);
        }
        catch (ArithmeticException | NumberFormatException e) {
            InfChest.LOGGER.error("TileInfChest loading problem.", (Throwable)e);
            this.count = BigInteger.ZERO;
        }
        this.customName = valueInput.method_71426(NBT_CUSTOM_NAME, class_8824.field_46597).orElse(null);
        class_1262.method_5429((class_11368)valueInput, this.inventory);
        this.updateInv();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    @NotNull
    public class_2561 method_5477() {
        if (this.customName != null) {
            return this.customName;
        }
        return class_2561.method_43471((String)InfChest.accessor.CHEST().method_63499());
    }

    public void setCustomName(@Nullable class_2561 name) {
        this.customName = name;
    }

    @NotNull
    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    @Override
    public int method_5439() {
        return 2;
    }

    @Override
    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960) && this.holding.method_7960();
    }

    @Override
    public class_1799 method_5438(int index) {
        return (class_1799)this.inventory.get(index);
    }

    @Override
    public class_1799 method_5434(int index, int count) {
        class_1799 s = class_1262.method_5430(this.inventory, (int)index, (int)count);
        if (index == 1) {
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.decrStack(BigInteger.valueOf(s.method_7947()));
            }
            this.method_5431();
        }
        return s;
    }

    @Override
    public class_1799 method_5441(int index) {
        class_1799 s = class_1262.method_5428(this.inventory, (int)index);
        if (index == 1) {
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.decrStack(BigInteger.valueOf(s.method_7947()));
            }
            this.method_5431();
        }
        return s;
    }

    @Override
    public void method_5447(int index, class_1799 stack) {
        class_1799 before = (class_1799)this.inventory.set(index, (Object)stack);
        if (index == 1 && this.field_11863 != null && !this.field_11863.method_8608()) {
            if (!stack.method_7960() && TileInfChest.stacksEqual(this.holding, stack)) {
                this.count = this.count.add(BigInteger.valueOf(stack.method_7947()));
            }
            this.decrStack(BigInteger.valueOf(before.method_7947()));
        }
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        this.updateInv();
    }

    @Override
    public void method_5435(class_11565 user) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.runUpdates();
        }
    }

    public void updateInv() {
        class_1799 insert = this.method_5438(0);
        if (!insert.method_7960() && this.method_5437(0, insert)) {
            this.addStack(insert);
        }
        if (this.holding.method_7960()) {
            this.inventory.set(1, (Object)class_1799.field_8037);
        } else {
            class_1799 out = this.method_5438(1);
            if (out.method_7960() || TileInfChest.stacksEqual(this.holding, out)) {
                int expectedCount = this.totalCount().min(BigInteger.valueOf(this.holding.method_7914())).intValueExact();
                this.inventory.set(1, (Object)TileInfChest.copyAmount(this.holding, expectedCount));
            }
        }
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.runUpdates();
        }
    }

    protected void addStack(class_1799 insert) {
        this.addStack(insert, BigInteger.valueOf(insert.method_7947()));
    }

    public void addStack(class_1799 insert, BigInteger add) {
        Optional<InsertingHook.Hook> hookObject = this.hook.findHookObject(insert);
        if (hookObject.isPresent()) {
            hookObject.ifPresent(h -> {
                this.count = this.count.add(h.getCount(insert));
                this.inventory.set(0, (Object)h.removeAllItems(insert));
            });
        } else {
            this.count = this.count.add(add);
            if (this.holding.method_7960()) {
                this.holding = TileInfChest.copyAmount(insert, 1);
            }
            this.inventory.set(0, (Object)class_1799.field_8037);
        }
    }

    public void decrStack(BigInteger subs) {
        if (subs.compareTo(this.count) > 0) {
            throw new IllegalArgumentException("subs > count");
        }
        this.count = this.count.subtract(subs);
        if (this.count.equals(BigInteger.ZERO)) {
            this.holding = class_1799.field_8037;
        }
    }

    public class_1799 getHolding() {
        if (!this.holding.method_7960()) {
            return TileInfChest.copyAmount(this.holding, INT_MAX.min(this.totalCount()).intValueExact());
        }
        class_1799 out = this.method_5438(1);
        if (!out.method_7960()) {
            return out.method_7972();
        }
        return class_1799.field_8037;
    }

    public class_1799 getHoldingWithOneCount() {
        if (!this.holding.method_7960()) {
            return TileInfChest.copyAmount(this.holding, 1);
        }
        class_1799 out = this.method_5438(1);
        if (!out.method_7960()) {
            return TileInfChest.copyAmount(out, 1);
        }
        return class_1799.field_8037;
    }

    public BigInteger totalCount() {
        return this.count;
    }

    public void setCount(@NotNull BigInteger count) {
        this.count = count;
    }

    public void setHolding(class_1799 holding) {
        this.holding = holding;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.method_11016()) == this && player.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) <= 64.0;
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            Optional<InsertingHook.Hook> hookObject = this.hook.findHookObject(stack);
            class_1799 secondStack = this.method_5438(1);
            return this.holding.method_7960() && hookObject.isEmpty() && (secondStack.method_7960() || TileInfChest.stacksEqual(secondStack, stack)) || TileInfChest.stacksEqual(this.holding, stack) || hookObject.filter(h -> h.checkItemAcceptable(this.holding, stack, TileUtil.providerFromEntity(this))).isPresent();
        }
        return false;
    }

    public boolean canInsertFromOutside(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (!this.method_5438(0).method_7960()) {
            return false;
        }
        if (this.holding.method_7960()) {
            return true;
        }
        return class_1799.method_31577((class_1799)this.holding, (class_1799)stack);
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
        this.holding = class_1799.field_8037;
        this.count = BigInteger.ZERO;
    }

    private static class_1799 copyAmount(class_1799 stack, int amount) {
        class_1799 copy = stack.method_7972();
        copy.method_7939(amount);
        return copy;
    }

    private static boolean stacksEqual(class_1799 s1, class_1799 s2) {
        return class_1799.method_31577((class_1799)s1, (class_1799)s2);
    }

    private static boolean gt(BigInteger bigInteger, int i) {
        return bigInteger.compareTo(BigInteger.valueOf(i)) > 0;
    }

    @Override
    public void addUpdate(Runnable runnable) {
        this.updateRunnable.add(runnable);
    }

    public List<Runnable> getUpdates() {
        return this.updateRunnable;
    }

    @Override
    public void runUpdateRemoveIf(Predicate<Runnable> predicate) {
        this.updateRunnable.removeIf(predicate);
    }

    public class_1703 createMenu(int containerID, class_1661 inventory, class_1657 player) {
        return new ContainerInfChest(containerID, inventory, this.method_11016());
    }

    public void method_66473(class_2338 pos, class_2680 state) {
    }

    public ChestItems getSnapshot() {
        return new ChestItems(this.method_5438(0), this.getHoldingWithOneCount().method_7972(), this.totalCount());
    }

    public void readSnapshot(ChestItems snapshot) {
        this.holding = snapshot.holding.method_7972();
        this.count = snapshot.count;
        this.inventory.set(0, (Object)snapshot.inputSlot.method_7972());
        this.method_5431();
    }

    public record ChestItems(class_1799 inputSlot, class_1799 holding, BigInteger count) {
    }
}

