/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.fabric.tiles;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.tiles.TileInfChest;
import com.kotori316.infchest.fabric.tiles.TileInfChestFabric;
import java.math.BigInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import org.jetbrains.annotations.VisibleForTesting;

public final class InfChestStorage
extends SnapshotParticipant<TileInfChest.ChestItems>
implements SingleSlotStorage<ItemVariant> {
    private final TileInfChestFabric chest;

    @VisibleForTesting
    InfChestStorage(TileInfChestFabric chest) {
        this.chest = chest;
    }

    protected TileInfChest.ChestItems createSnapshot() {
        return this.chest.getSnapshot();
    }

    protected void readSnapshot(TileInfChest.ChestItems snapshot) {
        this.chest.readSnapshot(snapshot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.matches(this.chest.getHolding()) || this.chest.getHolding().method_7960()) {
            this.updateSnapshots(transaction);
            this.chest.addStack(resource.toStack(1), BigInteger.valueOf(maxAmount));
            return maxAmount;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted;
        this.updateSnapshots(transaction);
        if (resource.matches(this.chest.getHoldingWithOneCount())) {
            BigInteger toTake = BigInteger.valueOf(maxAmount);
            if (this.chest.totalCount().compareTo(toTake) >= 0) {
                extracted = maxAmount;
                this.chest.decrStack(toTake);
            } else {
                extracted = this.chest.totalCount().longValueExact();
                this.chest.decrStack(this.chest.totalCount());
            }
        } else {
            extracted = 0L;
        }
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.chest.totalCount().equals(BigInteger.ZERO);
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.chest.getHoldingWithOneCount());
    }

    public long getAmount() {
        return this.chest.totalCount().min(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public static void register() {
        ItemStorage.SIDED.registerForBlocks((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof TileInfChestFabric) {
                TileInfChestFabric chest = (TileInfChestFabric)blockEntity;
                return new InfChestStorage(chest);
            }
            return null;
        }, new class_2248[]{InfChest.accessor.CHEST()});
    }
}

