/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.blocks;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.blocks.ItemInfChest;
import com.kotori316.infchest.common.integration.StorageBoxStack;
import com.kotori316.infchest.common.tiles.TileInfChest;
import com.kotori316.infchest.common.tiles.TileUtil;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class BlockInfChest
extends BaseEntityBlock {
    public static final String name = "infchest";
    public final BlockItem itemBlock = new ItemInfChest(this);
    protected final MapCodec<? extends BlockInfChest> blockCodec = BlockInfChest.simpleCodec(p -> (BlockInfChest)((Object)((Object)instanceSupplier.get())));

    public BlockInfChest(Supplier<? extends BlockInfChest> instanceSupplier) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.0f).isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)name, (String)name))));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return InfChest.accessor.INF_CHEST_TYPE().create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!player.isCrouching()) {
            if (!worldIn.isClientSide()) {
                if (StorageBoxStack.moveToStorage(worldIn, pos, player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                worldIn.getBlockEntity(pos, InfChest.accessor.INF_CHEST_TYPE()).ifPresent(t -> this.openGui((ServerPlayer)player, (TileInfChest)t, pos));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, worldIn, pos, player, hand, rayTrace);
    }

    protected abstract void openGui(ServerPlayer var1, TileInfChest var2, BlockPos var3);

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            worldIn.getBlockEntity(pos, InfChest.accessor.INF_CHEST_TYPE()).ifPresent(chest -> chest.setCustomName(stack.getDisplayName()));
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack pickBlock = super.getCloneItemStack(world, pos, state, includeData);
        BlockInfChest.saveChestNbtToStack(world.getBlockEntity(pos), pickBlock);
        BlockInfChest.saveCustomName(world.getBlockEntity(pos), pickBlock);
        return pickBlock;
    }

    public static void saveCustomName(@Nullable BlockEntity te, ItemStack drop) {
        Optional.ofNullable(te).filter(TileInfChest.class::isInstance).map(TileInfChest.class::cast).filter(Nameable::hasCustomName).map(TileInfChest::getName).ifPresent(c -> drop.set(DataComponents.CUSTOM_NAME, c));
    }

    public static void saveChestNbtToStack(@Nullable BlockEntity entity, ItemStack stack) {
        Optional.ofNullable(entity).filter(TileInfChest.class::isInstance).map(TileInfChest.class::cast).filter(Predicate.not(TileInfChest::isEmpty)).map(TileUtil::saveWithoutMetadata).ifPresent(tag -> BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)entity.getType(), (TagValueOutput)tag));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.blockCodec;
    }
}

