/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.integration;

import com.kotori316.infchest.common.tiles.TileInfChest;
import com.kotori316.infchest.common.tiles.TileUtil;
import java.math.BigInteger;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class CommonTooltipPart {
    private static final String NBT_KEY_ITEM = "tooltip_item";
    private static final String NBT_KEY_COUNT = "tooltip_count";

    public static List<Component> getTooltipBodyParts(CompoundTag data, BlockEntity entity) {
        ItemStack stack = TileUtil.parseItemStack(entity, data.getCompoundOrEmpty(NBT_KEY_ITEM));
        if (!stack.isEmpty()) {
            BigInteger integer = data.getByteArray(NBT_KEY_COUNT).map(BigInteger::new).orElse(BigInteger.ZERO);
            return List.of(stack.getDisplayName(), Component.literal((String)integer.toString()));
        }
        return List.of();
    }

    public static void addTileData(CompoundTag destination, BlockEntity maybeChest) {
        if (maybeChest instanceof TileInfChest) {
            TileInfChest chest = (TileInfChest)maybeChest;
            destination.put(NBT_KEY_ITEM, TileUtil.serializeItemStack(chest, chest.getItem(1)));
            destination.putByteArray(NBT_KEY_COUNT, chest.totalCount().toByteArray());
        }
    }
}

