/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.integration;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.tiles.InsertingHook;
import java.math.BigInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StorageBoxStack {
    public static final String modId = "storagebox";
    private static final String KEYSIZE = "StorageSize";
    private static final String KEY_ITEM_DATA = "StorageItemData";

    public static boolean isStorageBox(ItemStack maybeBox) {
        if (!Holder.modLoaded) {
            return false;
        }
        Item item = maybeBox.getItem();
        return item == BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)modId, (String)modId));
    }

    public static boolean checkHoldingItem(ItemStack holding, ItemStack maybeBox) {
        if (!Holder.modLoaded || holding.isEmpty()) {
            return false;
        }
        if (StorageBoxStack.isStorageBox(maybeBox)) {
            ItemStack inBox = StorageBoxStack.getItem(maybeBox);
            return !inBox.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)holding, (ItemStack)inBox);
        }
        return false;
    }

    public static BigInteger getCount(ItemStack maybeBox) {
        return BigInteger.ZERO;
    }

    public static ItemStack removeAllItems(ItemStack maybeBox) {
        return ItemStack.EMPTY;
    }

    public static boolean moveToStorage(Level worldIn, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return false;
    }

    private static ItemStack getItem(ItemStack box) {
        return ItemStack.EMPTY;
    }

    private static class Holder {
        public static final boolean modLoaded = InfChest.accessor.isModLoaded("storagebox");

        private Holder() {
        }
    }

    public static class StorageBoxHook
    implements InsertingHook.Hook {
        @Override
        public boolean isHookItem(ItemStack stack) {
            return StorageBoxStack.isStorageBox(stack);
        }

        @Override
        public BigInteger getCount(ItemStack hookItem) {
            return StorageBoxStack.getCount(hookItem);
        }

        @Override
        public ItemStack removeAllItems(ItemStack hookItem) {
            return StorageBoxStack.removeAllItems(hookItem);
        }

        @Override
        public boolean checkItemAcceptable(ItemStack chestContent, ItemStack hookItem, HolderLookup.Provider provider) {
            return StorageBoxStack.checkHoldingItem(chestContent, hookItem);
        }
    }
}

