/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.neoforge.tiles;

import com.kotori316.infchest.common.tiles.TileInfChest;
import com.kotori316.infchest.neoforge.tiles.TileInfChestNeoForge;
import java.math.BigInteger;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

final class InfItemHandler
extends SnapshotJournal<TileInfChest.ChestItems>
implements ResourceHandler<ItemResource> {
    private final TileInfChestNeoForge infChest;

    InfItemHandler(TileInfChestNeoForge infChest) {
        this.infChest = infChest;
    }

    protected TileInfChest.ChestItems createSnapshot() {
        return this.infChest.getSnapshot();
    }

    protected void revertToSnapshot(TileInfChest.ChestItems snapshot) {
        this.infChest.readSnapshot(snapshot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.infChest.setItem(slot, stack);
    }

    public int size() {
        return this.infChest.getContainerSize();
    }

    @NotNull
    public ItemResource getResource(int slot) {
        return ItemResource.of((ItemStack)this.infChest.getItem(slot));
    }

    public long getAmountAsLong(int index) {
        return this.infChest.getItem(index).getCount();
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (this.isValid(0, resource)) {
            this.updateSnapshots(transaction);
            this.infChest.addStack(resource.toStack(amount));
            this.infChest.setChanged();
            return amount;
        }
        return 0;
    }

    public int extract(int slot, ItemResource resource, int amount, TransactionContext transaction) {
        if (slot != 1) {
            return 0;
        }
        ItemStack item = this.infChest.getHolding();
        if (item.isEmpty()) {
            return 0;
        }
        this.updateSnapshots(transaction);
        BigInteger extractCount = this.infChest.totalCount().min(BigInteger.valueOf(amount));
        this.infChest.decrStack(extractCount);
        this.infChest.setChanged();
        return extractCount.intValueExact();
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        return this.infChest.getMaxStackSize();
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.infChest.canPlaceItem(index, resource.toStack());
    }

    public TileInfChestNeoForge infChest() {
        return this.infChest;
    }
}

