/*
 * Decompiled with CFR 0.152.
 */
package gravity_core_block_crakq44l.entity;

import gravity_core_block_crakq44l.GravityCoreBlock;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class GravityCoreBlockEntity
extends class_2586 {
    private static final int GRAVITY_RADIUS = 8;
    private static final double UPWARD_FORCE = 0.15;
    private boolean powered = false;
    private int tickCounter = 0;

    public GravityCoreBlockEntity(class_2338 pos, class_2680 state) {
        super(GravityCoreBlock.GRAVITY_CORE_BLOCK_ENTITY_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GravityCoreBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter % 2 == 0 && blockEntity.powered) {
            blockEntity.applyGravityEffect(world, pos);
        }
    }

    private void applyGravityEffect(class_1937 world, class_2338 centerPos) {
        class_238 effectArea = new class_238(centerPos).method_1014(8.0);
        List entities = world.method_8390(class_1297.class, effectArea, entity -> entity instanceof class_1309 || entity instanceof class_1542);
        for (class_1297 entity2 : entities) {
            double distance;
            if (entity2 instanceof class_1657) {
                class_1657 player = (class_1657)entity2;
                if (player.method_31549().field_7477) continue;
            }
            if (!((distance = entity2.method_19538().method_1022(centerPos.method_46558())) <= 8.0)) continue;
            double strength = (8.0 - distance) / 8.0;
            double upwardVelocity = 0.15 * strength;
            entity2.method_5762(0.0, upwardVelocity, 0.0);
            entity2.field_6037 = true;
            entity2.field_6017 = 0.0;
        }
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
        this.method_5431();
    }

    public boolean isPowered() {
        return this.powered;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("powered", this.powered);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.powered = nbt.method_10577("powered").orElse(false);
    }
}

