/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.customDay;

import ketoshi.customDay.TimeCommands;
import ketoshi.customDay.TimeTask;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class CustomDay
extends JavaPlugin {
    private BukkitTask timeTask;

    public void onEnable() {
        this.saveDefaultConfig();
        TimeCommands commandHandler = new TimeCommands(this);
        this.getCommand("customday").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("customday").setTabCompleter((TabCompleter)commandHandler);
        this.startTimeTask();
        this.getLogger().info("CustomDay has been enabled successfully!");
    }

    public void onDisable() {
        if (this.timeTask != null) {
            this.timeTask.cancel();
        }
        for (World world : this.getServer().getWorlds()) {
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
        }
        this.getLogger().info("CustomDay has been disabled.");
    }

    public void startTimeTask() {
        if (this.timeTask != null) {
            this.timeTask.cancel();
        }
        for (World world : this.getServer().getWorlds()) {
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        }
        this.timeTask = new TimeTask(this).runTaskTimer((Plugin)this, 0L, 1L);
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.startTimeTask();
    }

    public String getMessage(String path) {
        String message = this.getConfig().getString(path, "&cMessage not found: " + path);
        String prefix = this.getConfig().getString("messages.prefix", "&8[&eCustomDay&8] &r");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + message));
    }
}

