/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.customDay;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ketoshi.customDay.CustomDay;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class TimeCommands
implements CommandExecutor,
TabCompleter {
    private final CustomDay plugin;

    public TimeCommands(CustomDay plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getMessage(" &7Usage: /customday <subcommand>"));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "setday": 
            case "setnight": {
                this.handleSetDuration(sender, subCommand, args);
                break;
            }
            case "sync": {
                this.handleSync(sender, args);
                break;
            }
            case "reload": {
                this.plugin.reloadPlugin();
                sender.sendMessage(this.plugin.getMessage("messages.reload-success"));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getMessage(" &7Unknown subcommand."));
            }
        }
        return true;
    }

    private void handleSetDuration(CommandSender sender, String type, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessage(" &7Usage: /customday " + type + " <minutes>"));
            return;
        }
        try {
            int minutes = Integer.parseInt(args[1]);
            if (minutes <= 0) {
                sender.sendMessage(this.plugin.getMessage("messages.invalid-number"));
                return;
            }
            this.plugin.getConfig().set("custom-duration." + type.replace("set", "").toLowerCase() + "-minutes", (Object)minutes);
            this.plugin.getConfig().set("mode", (Object)"CUSTOM_DURATION");
            this.plugin.getConfig().set("real-time-sync.enabled", (Object)false);
            this.plugin.saveConfig();
            this.plugin.reloadPlugin();
            sender.sendMessage(this.plugin.getMessage("messages." + type.replace("set", "").toLowerCase() + "-duration-set").replace("{minutes}", String.valueOf(minutes)));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessage("messages.invalid-number"));
        }
    }

    private void handleSync(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessage(" &7Usage: /customday sync <timezone|on|off>"));
            return;
        }
        String action = args[1].toLowerCase();
        if (action.equals("off")) {
            this.plugin.getConfig().set("mode", (Object)"CUSTOM_DURATION");
            this.plugin.getConfig().set("real-time-sync.enabled", (Object)false);
            this.plugin.saveConfig();
            this.plugin.reloadPlugin();
            sender.sendMessage(this.plugin.getMessage("messages.sync-disabled"));
        } else if (action.equals("on")) {
            this.plugin.getConfig().set("mode", (Object)"REAL_TIME_SYNC");
            this.plugin.getConfig().set("real-time-sync.enabled", (Object)true);
            this.plugin.saveConfig();
            this.plugin.reloadPlugin();
            String currentTz = this.plugin.getConfig().getString("real-time-sync.timezone");
            sender.sendMessage(this.plugin.getMessage("messages.sync-enabled-existing").replace("{timezone}", currentTz));
        } else {
            String timezoneId = args[1];
            if (ZoneId.getAvailableZoneIds().contains(timezoneId)) {
                this.plugin.getConfig().set("real-time-sync.timezone", (Object)timezoneId);
                this.plugin.getConfig().set("real-time-sync.enabled", (Object)true);
                this.plugin.getConfig().set("mode", (Object)"REAL_TIME_SYNC");
                this.plugin.saveConfig();
                this.plugin.reloadPlugin();
                sender.sendMessage(this.plugin.getMessage("messages.sync-enabled").replace("{timezone}", timezoneId));
            } else {
                sender.sendMessage(this.plugin.getMessage("messages.invalid-timezone").replace("{timezone}", timezoneId));
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("setday", "setnight", "sync", "reload"), new ArrayList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("sync")) {
            List suggestions = ZoneId.getAvailableZoneIds().stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            suggestions.addAll(Arrays.asList("on", "off"));
            return (List)StringUtil.copyPartialMatches((String)args[1], suggestions, new ArrayList());
        }
        return Collections.emptyList();
    }
}

