/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.customDay;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import ketoshi.customDay.CustomDay;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class TimeTask
extends BukkitRunnable {
    private final CustomDay plugin;
    private final World overworld;
    private double tickAccumulator = 0.0;
    private long lastSecondCheck = 0L;

    public TimeTask(CustomDay plugin) {
        this.plugin = plugin;
        this.overworld = (World)Bukkit.getServer().getWorlds().get(0);
    }

    public void run() {
        String mode = this.plugin.getConfig().getString("mode", "CUSTOM_DURATION");
        if ("REAL_TIME_SYNC".equalsIgnoreCase(mode)) {
            long currentSecond = System.currentTimeMillis() / 1000L;
            if (currentSecond != this.lastSecondCheck) {
                this.lastSecondCheck = currentSecond;
                this.handleRealTimeSync();
            }
        } else {
            this.handleCustomDuration();
        }
    }

    private void handleCustomDuration() {
        long dayMinutes = this.plugin.getConfig().getLong("custom-duration.day-minutes", 10L);
        long nightMinutes = this.plugin.getConfig().getLong("custom-duration.night-minutes", 10L);
        if (dayMinutes <= 0L) {
            dayMinutes = 1L;
        }
        if (nightMinutes <= 0L) {
            nightMinutes = 1L;
        }
        double daySpeed = 12000.0 / (double)(dayMinutes * 60L * 20L);
        double nightSpeed = 12000.0 / (double)(nightMinutes * 60L * 20L);
        long currentTime = this.overworld.getTime();
        boolean isDay = currentTime >= 0L && currentTime < 12000L;
        this.tickAccumulator += isDay ? daySpeed : nightSpeed;
        if (this.tickAccumulator >= 1.0) {
            long ticksToAdd = (long)this.tickAccumulator;
            this.overworld.setTime(this.overworld.getTime() + ticksToAdd);
            this.tickAccumulator -= (double)ticksToAdd;
        }
    }

    private void handleRealTimeSync() {
        String timezoneId = this.plugin.getConfig().getString("real-time-sync.timezone", "UTC");
        try {
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of(timezoneId));
            long secondsOfDay = now.getLong(ChronoField.SECOND_OF_DAY);
            long offsetSeconds = secondsOfDay - 21600L;
            if (offsetSeconds < 0L) {
                offsetSeconds += 86400L;
            }
            long minecraftTime = (long)((double)offsetSeconds * 0.2777777777777778);
            this.overworld.setTime(minecraftTime);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid timezone ID '" + timezoneId + "' in config.yml. Real-time sync is paused.");
            this.cancel();
        }
    }
}

