/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.WorldGroup;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface GroupProvider {
    @Contract(pure=true)
    public Path getDataFolder();

    @Contract(pure=true)
    public @Unmodifiable Set<WorldGroup> getAllGroups();

    public @Unmodifiable Set<WorldGroup> getGroups();

    @Contract(pure=true)
    public Optional<WorldGroup> getGroup(String var1);

    @Contract(pure=true)
    public Optional<WorldGroup> getGroup(World var1);

    @Contract(pure=true)
    public WorldGroup getUnownedWorldGroup();

    @Contract(value="_, _, _, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, Consumer<GroupData> var2, Consumer<GroupSettings> var3, Collection<World> var4) throws IllegalStateException;

    @Contract(value="_, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, Collection<World> var2) throws IllegalStateException;

    @Contract(value="_, _, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, Consumer<GroupData> var2, World ... var3) throws IllegalStateException;

    @Contract(value="_, _, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, Consumer<GroupData> var2, Collection<World> var3) throws IllegalStateException;

    @Contract(value="_, _, _, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, Consumer<GroupData> var2, Consumer<GroupSettings> var3, World ... var4) throws IllegalStateException;

    @Contract(value="_, _ -> new", mutates="this")
    public WorldGroup createGroup(String var1, World ... var2) throws IllegalStateException;

    @Contract(pure=true)
    public boolean hasGroup(String var1);

    @Contract(pure=true)
    public boolean hasGroup(World var1);

    @Contract(pure=true)
    public boolean hasGroup(WorldGroup var1);

    @Contract(mutates="this")
    public boolean removeGroup(String var1);

    @Contract(mutates="this")
    public boolean removeGroup(WorldGroup var1);

    @Contract(pure=true)
    public boolean isLoadingData(Player var1);
}

