/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.adapter;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.perworlds.GroupData;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.group.PaperGroupData;
import net.thenextlvl.perworlds.group.PaperGroupSettings;
import net.thenextlvl.perworlds.model.config.GroupConfig;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GroupConfigAdapter
implements TagAdapter<GroupConfig> {
    @Override
    public GroupConfig deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        GroupData data = tag.getAsCompound().optional("data").map(tag1 -> context.deserialize((Tag)tag1, GroupData.class)).orElseGet(PaperGroupData::new);
        GroupSettings settings = tag.getAsCompound().optional("settings").map(tag1 -> context.deserialize((Tag)tag1, GroupSettings.class)).orElseGet(PaperGroupSettings::new);
        Set worlds = tag.getAsCompound().optional("worlds").map(Tag::getAsList).map(tags -> tags.stream().map(world -> context.deserialize((Tag)world, Key.class)).collect(Collectors.toSet())).orElseGet(HashSet::new);
        return new GroupConfig(worlds, data, settings);
    }

    @Override
    public Tag serialize(GroupConfig config, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        tag.add("data", context.serialize(config.data()));
        tag.add("settings", context.serialize(config.settings()));
        if (!config.worlds().isEmpty()) {
            tag.add("worlds", ListTag.of(config.worlds().stream().map(context::serialize).toList()));
        }
        return tag;
    }
}

