/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.command.brigadier.SimpleCommand;
import net.thenextlvl.perworlds.group.PaperWorldGroup;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Contract;

final class GroupAutoCommand
extends SimpleCommand {
    private GroupAutoCommand(PerWorldsPlugin plugin) {
        super(plugin, "auto", "perworlds.command.group.auto");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(PerWorldsPlugin plugin) {
        GroupAutoCommand command = new GroupAutoCommand(plugin);
        return (LiteralArgumentBuilder)command.create().executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        AtomicInteger groupCount = new AtomicInteger();
        AtomicInteger worldCount = new AtomicInteger();
        this.autoGroup(this.plugin.getServer().getWorlds()).forEach((worlds, name) -> {
            block3: {
                block2: {
                    if (worlds.size() == 1) break block2;
                    if (!worlds.stream().allMatch(this.plugin.groupProvider()::hasGroup)) break block3;
                }
                worlds.forEach(world -> this.plugin.bundle().sendMessage((Audience)sender, "group.auto.skipped", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName())}));
                return;
            }
            PaperWorldGroup group = this.plugin.groupProvider().createGroup(this.plugin.groupProvider().findFreeName((String)name), new World[0]);
            this.plugin.bundle().sendMessage((Audience)sender, "group.auto.created", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName())});
            groupCount.incrementAndGet();
            worlds.forEach(world -> {
                boolean added = group.addWorld((World)world);
                if (added) {
                    worldCount.incrementAndGet();
                }
                String message = added ? "group.world.added" : "group.auto.failed";
                this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName()), Placeholder.parsed((String)"group", (String)group.getName())});
            });
        });
        this.plugin.bundle().sendMessage((Audience)sender, "group.auto.done", Formatter.number((String)"groups", (Number)groupCount.get()), Formatter.number((String)"worlds", (Number)worldCount.get()));
        return 0;
    }

    @Contract(pure=true)
    private Map<List<World>, String> autoGroup(List<World> worlds) {
        Map<String, List<World>> groups = worlds.stream().collect(Collectors.groupingBy(world -> world.key().namespace()));
        HashMap<List<World>, String> result = new HashMap<List<World>, String>();
        for (Map.Entry<String, List<World>> entry : groups.entrySet()) {
            ArrayList nameGroups = new ArrayList();
            for (World world2 : entry.getValue()) {
                boolean added = false;
                List<String> worldParts = this.splitParts(world2.getName());
                for (List list : nameGroups) {
                    List<String> groupParts = this.splitParts(((World)list.getFirst()).getName());
                    long matches = this.countMatches(worldParts, groupParts);
                    if (matches <= 0L) continue;
                    list.add(world2);
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<World> newGroup = new ArrayList<World>();
                newGroup.add(world2);
                nameGroups.add(newGroup);
            }
            for (List list : nameGroups) {
                String name = this.mostCommonPart(list).orElse(entry.getKey());
                result.put(list, name);
            }
        }
        return result;
    }

    @Contract(pure=true)
    private long countMatches(List<String> a, List<String> b) {
        return a.stream().filter(b::contains).count();
    }

    @Contract(pure=true)
    private Optional<String> mostCommonPart(List<World> worlds) {
        HashMap<String, Integer> partCount = new HashMap<String, Integer>();
        for (World world : worlds) {
            for (String part : this.splitParts(world.getName())) {
                partCount.put(part, partCount.getOrDefault(part, 0) + 1);
            }
        }
        return partCount.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    @Contract(pure=true)
    private List<String> splitParts(String name) {
        return List.of(name.toLowerCase().split("[\\-_\\s]+"));
    }
}

