/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.command.WorldCommand;
import net.thenextlvl.perworlds.command.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class GroupTeleportCommand
extends SimpleCommand {
    private GroupTeleportCommand(PerWorldsPlugin plugin) {
        super(plugin, "teleport", "perworlds.command.group.teleport");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(PerWorldsPlugin plugin) {
        GroupTeleportCommand command = new GroupTeleportCommand(plugin);
        return command.create().then(((RequiredArgumentBuilder)WorldCommand.groupArgument(plugin, true).then(Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).executes((Command)command))).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<Player> players;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        WorldGroup group = (WorldGroup)context.getArgument("group", WorldGroup.class);
        if (!group.getSettings().enabled()) {
            this.plugin.bundle().sendMessage((Audience)sender, "group.teleport.disabled", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName())});
            return 0;
        }
        PlayerSelectorArgumentResolver resolver = this.tryGetArgument(context, "players", PlayerSelectorArgumentResolver.class).orElse(null);
        if (resolver != null) {
            v0 = (List<Player>)resolver.resolve((CommandSourceStack)context.getSource());
        } else if (sender instanceof Player) {
            Player player2 = (Player)sender;
            v0 = List.of(player2);
        } else {
            v0 = players = null;
        }
        if (players == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }
        List<Player> filtered = players.stream().filter(player -> !group.containsWorld(player.getWorld())).toList();
        filtered.forEach(player -> group.loadPlayerData((Player)player, true).thenAccept(success -> this.plugin.bundle().sendMessage((Audience)player, success != false ? "group.teleport.self" : "group.teleport.failed", new TagResolver[]{Placeholder.parsed((String)"group", (String)group.getName())})));
        if (filtered.size() == 1 && filtered.getFirst().equals((Object)sender)) {
            return 1;
        }
        String message = group.getWorlds().findAny().isEmpty() ? "group.teleport.empty" : (filtered.size() == 1 ? "group.teleport.other" : (filtered.isEmpty() ? "group.teleport.none" : "group.teleport.others"));
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)(filtered.isEmpty() ? Component.empty() : filtered.getFirst().name())), Formatter.number((String)"players", (Number)filtered.size()), Placeholder.parsed((String)"group", (String)group.getName())});
        return filtered.isEmpty() ? 0 : 1;
    }
}

