/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.perworlds.PerWorldsPlugin;
import net.thenextlvl.perworlds.WorldGroup;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GroupArgument
implements CustomArgumentType.Converted<WorldGroup, String> {
    private final PerWorldsPlugin plugin;
    private final boolean listAll;

    public GroupArgument(PerWorldsPlugin plugin, boolean listAll) {
        this.plugin = plugin;
        this.listAll = listAll;
    }

    public WorldGroup convert(String nativeType) {
        return this.plugin.groupProvider().getGroup(nativeType).orElseThrow(() -> new RuntimeException("Group not found"));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Set<WorldGroup> groups = this.listAll ? this.plugin.groupProvider().getAllGroups() : this.plugin.groupProvider().getGroups();
        groups.stream().map(WorldGroup::getName).filter(name -> name.contains(builder.getRemaining())).map(StringArgumentType::escapeIfRequired).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }
}

