/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.thenextlvl.perworlds.data.AdvancementDataImpl;
import org.bukkit.advancement.Advancement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.NonExtendable
public interface AdvancementData {
    @Contract(pure=true)
    public Advancement getAdvancement();

    @Contract(pure=true)
    public boolean isDone();

    @Contract(pure=true)
    public boolean hasProgress();

    @Contract(mutates="this")
    public boolean awardCriteria(String var1);

    @Contract(mutates="this")
    public boolean revokeCriteria(String var1);

    @Contract(pure=true)
    public @Nullable Instant getTimeAwarded(String var1);

    @Contract(mutates="this")
    public boolean setTimeAwarded(String var1, Instant var2);

    @Contract(pure=true)
    public @Unmodifiable Set<String> getRemainingCriteria();

    @Contract(pure=true)
    public @Unmodifiable Set<String> getAwardedCriteria();

    public void forEachAwardedCriteria(BiConsumer<String, Instant> var1);

    @Contract(value="_ -> new", pure=true)
    public static AdvancementData of(Advancement advancement) {
        return new AdvancementDataImpl(advancement, Map.of(), advancement.getCriteria());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static AdvancementData of(Advancement advancement, Map<String, Instant> awardedCriteria, Collection<String> remainingCriteria) {
        return new AdvancementDataImpl(advancement, awardedCriteria, remainingCriteria);
    }
}

