/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import net.thenextlvl.perworlds.data.WardenSpawnTrackerImpl;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface WardenSpawnTracker {
    @Contract(pure=true)
    public int cooldownTicks();

    @Contract(value="_ -> new", pure=true)
    public WardenSpawnTracker cooldownTicks(int var1);

    @Contract(pure=true)
    public int ticksSinceLastWarning();

    @Contract(value="_ -> new", pure=true)
    public WardenSpawnTracker ticksSinceLastWarning(int var1);

    @Contract(pure=true)
    public int warningLevel();

    @Contract(value="_ -> new", pure=true)
    public WardenSpawnTracker warningLevel(int var1);

    @Contract(value="_ -> new", pure=true)
    public static WardenSpawnTracker of(Player player) {
        return new WardenSpawnTrackerImpl(player);
    }

    @Contract(value=" -> new", pure=true)
    public static WardenSpawnTracker create() {
        return new WardenSpawnTrackerImpl(0, 0, 0);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static WardenSpawnTracker create(int cooldownTicks, int ticksSinceLastWarning, int warningLevel) {
        return new WardenSpawnTrackerImpl(cooldownTicks, ticksSinceLastWarning, warningLevel);
    }
}

