/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.data;

import io.papermc.paper.math.Position;
import net.thenextlvl.perworlds.data.WorldBorderDataImpl;
import org.bukkit.WorldBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface WorldBorderData {
    public static final WorldBorderData DEFAULT = new WorldBorderDataImpl();

    @Contract(pure=true)
    public double centerX();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData centerX(double var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public double centerZ();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData centerZ(double var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public Position center();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData center(Position var1) throws IllegalArgumentException;

    @Contract(value="_, _ -> new", pure=true)
    public WorldBorderData center(double var1, double var3) throws IllegalArgumentException;

    @Contract(pure=true)
    public double size();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData size(double var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public long duration();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData duration(long var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public double damageAmount();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData damageAmount(double var1);

    @Contract(pure=true)
    public double damageBuffer();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData damageBuffer(double var1);

    @Contract(pure=true)
    public int warningDistance();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData warningDistance(int var1);

    @Contract(pure=true)
    public int warningTime();

    @Contract(value="_ -> new", pure=true)
    public WorldBorderData warningTime(int var1);

    @Contract(pure=true)
    public static double getMaxSize() {
        return 5.9999968E7;
    }

    @Contract(pure=true)
    public static double getMinSize() {
        return 1.0;
    }

    @Contract(pure=true)
    public static double getMaxCenterCoordinate() {
        return 5.9999968E7;
    }

    @Contract(value="_, _, _, _, _, _, _, _ -> new", pure=true)
    public static WorldBorderData create(double centerX, double centerZ, double size, double damageAmount, double damageBuffer, long duration, int warningDistance, int warningTime) {
        return new WorldBorderDataImpl(centerX, centerZ, size, damageAmount, damageBuffer, duration, warningDistance, warningTime);
    }

    public static WorldBorderData of(WorldBorder border) {
        return new WorldBorderDataImpl(border);
    }
}

