/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.listener;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.thenextlvl.perworlds.GroupProvider;
import net.thenextlvl.perworlds.GroupSettings;
import net.thenextlvl.perworlds.WorldGroup;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class MessageListener
implements Listener {
    private final GroupProvider provider;

    public MessageListener(GroupProvider provider) {
        this.provider = provider;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerAdvancementDone(PlayerAdvancementDoneEvent event) {
        this.handle(event.getPlayer().getWorld(), (GameRule<Boolean>)GameRule.ANNOUNCE_ADVANCEMENTS, GroupSettings::advancementMessages, arg_0 -> ((PlayerAdvancementDoneEvent)event).message(arg_0), event.message());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.handle(event.getPlayer().getWorld(), (GameRule<Boolean>)GameRule.SHOW_DEATH_MESSAGES, GroupSettings::deathMessages, arg_0 -> ((PlayerDeathEvent)event).deathMessage(arg_0), event.deathMessage());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.handle(event.getPlayer().getWorld(), null, GroupSettings::joinMessages, arg_0 -> ((PlayerJoinEvent)event).joinMessage(arg_0), event.joinMessage());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handle(event.getPlayer().getWorld(), null, GroupSettings::quitMessages, arg_0 -> ((PlayerQuitEvent)event).quitMessage(arg_0), event.quitMessage());
    }

    private void handle(World world, @Nullable GameRule<Boolean> gameRule, Predicate<GroupSettings> enabled, Consumer<@Nullable Component> disable, @Nullable Component message) {
        if (message == null) {
            return;
        }
        List<Player> receivers = this.receivers(world, gameRule, enabled);
        if (receivers == null) {
            return;
        }
        receivers.forEach(player -> player.sendMessage(message));
        disable.accept(null);
    }

    private @Nullable List<Player> receivers(World world, @Nullable GameRule<Boolean> gameRule, Predicate<GroupSettings> enabled) {
        if (!this.canReceive(gameRule, world)) {
            return null;
        }
        WorldGroup group = this.provider.getGroup(world).orElse(this.provider.getUnownedWorldGroup());
        return group.getSettings().enabled() && enabled.test(group.getSettings()) ? group.getPlayers() : this.provider.getAllGroups().stream().filter(target -> !enabled.test(target.getSettings())).filter(target -> this.canReceive(gameRule, (WorldGroup)target)).map(WorldGroup::getPlayers).flatMap(Collection::stream).toList();
    }

    private boolean canReceive(@Nullable GameRule<Boolean> gameRule, WorldGroup group) {
        return gameRule == null || group.getGroupData().getGameRule(gameRule).or(() -> group.getWorlds().findAny().map(world -> this.canReceive(gameRule, (World)world))).orElse(true) != false;
    }

    private boolean canReceive(@Nullable GameRule<Boolean> gameRule, World world) {
        return gameRule == null || Boolean.TRUE.equals(world.getGameRuleValue(gameRule));
    }
}

