/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.perworlds.listener;

import net.thenextlvl.perworlds.WorldGroup;
import net.thenextlvl.perworlds.group.PaperGroupProvider;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TeleportListener
implements Listener {
    private final PaperGroupProvider provider;

    public TeleportListener(PaperGroupProvider provider) {
        this.provider = provider;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        WorldGroup to;
        if (event.getFrom().getWorld().equals((Object)event.getTo().getWorld())) {
            return;
        }
        WorldGroup from = this.provider.getGroup(event.getFrom().getWorld()).orElse(this.provider.getUnownedWorldGroup());
        if (!from.equals(to = this.provider.getGroup(event.getTo().getWorld()).orElse(this.provider.getUnownedWorldGroup()))) {
            from.persistPlayerData(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        WorldGroup to;
        WorldGroup from = this.provider.getGroup(event.getFrom()).orElse(this.provider.getUnownedWorldGroup());
        if (!from.equals(to = this.provider.getGroup(event.getPlayer().getWorld()).orElse(this.provider.getUnownedWorldGroup()))) {
            to.loadPlayerData(event.getPlayer());
        }
    }
}

