/*
 * Decompiled with CFR 0.152.
 */
package io.github.moehreag.legacylwjgl3;

import io.github.moehreag.legacylwjgl3.LegacyLWJGL3;
import io.github.moehreag.legacylwjgl3.util.XDGPathResolver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.commons.io.IOUtils;

public class DesktopFileInjector {
    public static final String APP_ID = "com.mojang.minecraft";
    private static final String ICON_NAME = "minecraft.png";
    private static final String FILE_NAME = "com.mojang.minecraft.desktop";
    private static final String RESOURCE_LOCATION = "/assets/legacy-lwjgl3/com.mojang.minecraft.desktop";
    private static final List<Path> injectedLocations = new ArrayList<Path>();

    public static void inject() {
        if (Boolean.getBoolean("legacy_lwjgl3.disable_desktopfile_injection") || System.getenv("LEGACY_LWJGL3_DISABLE_DESKTOPFILE_INJECTION") != null) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(DesktopFileInjector::uninject));
        try (InputStream stream = DesktopFileInjector.class.getResourceAsStream(RESOURCE_LOCATION);){
            Path location = DesktopFileInjector.getDesktopFileLocation();
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(IllegalStateException::new)).getMetadata().getVersion().getFriendlyString();
            DesktopFileInjector.injectFile(location, String.format(IOUtils.toString((InputStream)Objects.requireNonNull(stream)), version, ICON_NAME.substring(0, ICON_NAME.lastIndexOf("."))).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LegacyLWJGL3.LOGGER.error("Failed to inject icon: ", (Throwable)e);
        }
    }

    public static int setIcon(ByteBuffer[] icons) {
        for (ByteBuffer buf : icons) {
            try {
                int[] pixels = new int[buf.remaining() / 4];
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = Integer.rotateRight(buf.getInt(), 8);
                }
                int size = (int)Math.sqrt(pixels.length);
                BufferedImage image = new BufferedImage(size, size, 2);
                image.setRGB(0, 0, size, size, pixels, 0, size);
                Path target = DesktopFileInjector.getIconFileLocation(image.getWidth(), image.getHeight());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", outputStream);
                DesktopFileInjector.injectFile(target, outputStream.toByteArray());
            }
            catch (IOException e) {
                return 1;
            }
        }
        DesktopFileInjector.updateIconSystem();
        return 0;
    }

    private static void injectFile(Path target, byte[] data) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.write(target, data, new OpenOption[0]);
            injectedLocations.add(target);
        }
        catch (IOException e) {
            LegacyLWJGL3.LOGGER.error("Failed to inject file: ", (Throwable)e);
        }
    }

    private static Path getIconFileLocation(int width, int height) {
        return XDGPathResolver.getUserDataLocation().resolve("icons/hicolor").resolve(width + "x" + height).resolve("apps").resolve(ICON_NAME);
    }

    private static Path getDesktopFileLocation() {
        return XDGPathResolver.getUserDataLocation().resolve("applications").resolve(FILE_NAME);
    }

    private static void updateIconSystem() {
        ProcessBuilder builder = new ProcessBuilder("xdg-icon-resource", "forceupdate");
        try {
            builder.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void uninject() {
        injectedLocations.forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        DesktopFileInjector.updateIconSystem();
    }
}

