/*
 * Decompiled with CFR 0.152.
 */
package io.github.moehreag.legacylwjgl3;

import io.github.moehreag.legacylwjgl3.LegacyLWJGL3;
import io.github.moehreag.legacylwjgl3.annotations.CreateStub;
import io.github.moehreag.legacylwjgl3.annotations.Public;
import io.github.moehreag.legacylwjgl3.util.CodeGen;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class Lwjgl3MixinPostProcessor
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        Lwjgl3MixinPostProcessor.getPaulscodePath().ifPresent(arg_0 -> Lwjgl3MixinPostProcessor.lambda$onLoad$0(FabricLauncherBase.getLauncher(), arg_0));
    }

    public static Optional<Path> getPaulscodePath() {
        for (Path path : FabricLauncherBase.getLauncher().getClassPath()) {
            if (!path.toString().contains("librarylwjglopenal")) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static void processPublic(ClassNode target, MethodNode method) {
        if (Annotations.getInvisible((MethodNode)method, Public.class) == null) {
            return;
        }
        if ((method.access & 8) == 0) {
            LegacyLWJGL3.LOGGER.warn("[L3MPP] non static method annotated with @Public");
            return;
        }
        LegacyLWJGL3.LOGGER.debug("[L3MPP] Injected public static method {}::{}{}", new Object[]{target.name, method.name, method.desc});
        method.access &= 0xFFFFFFF9;
        method.access |= 1;
    }

    private static void processStub(ClassNode target, MethodNode method) {
        AnnotationNode node = Annotations.getInvisible((MethodNode)method, CreateStub.class);
        if (node == null) {
            return;
        }
        MethodNode stub = CodeGen.createDelegatingMethod(target, method, (String)Annotations.getValue((AnnotationNode)node));
        target.methods.add(stub);
        LegacyLWJGL3.LOGGER.debug("[L3MPP] Created method {}::[{} -> {}]{}", new Object[]{target.name, stub.name, method.name, method.desc});
    }

    public void postApply(String targetClassName, ClassNode target, String mixinClassName, IMixinInfo mixinInfo) {
        for (MethodNode method : new ArrayList(target.methods)) {
            Lwjgl3MixinPostProcessor.processPublic(target, method);
            Lwjgl3MixinPostProcessor.processStub(target, method);
        }
    }

    private static /* synthetic */ void lambda$onLoad$0(FabricLauncher rec$, Path x$0) {
        rec$.addToClassPath(x$0, new String[0]);
    }
}

