/*
 * Decompiled with CFR 0.152.
 */
package io.github.moehreag.legacylwjgl3.implementation.glfw;

import io.github.moehreag.legacylwjgl3.implementation.input.MouseImplementation;
import io.github.moehreag.legacylwjgl3.util.XDGPathResolver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0979881;
import net.minecraft.unmapped.C_2966580;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_7669754;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_9639106;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EventQueue;

public class VirtualGLFWMouseImplementation
implements MouseImplementation {
    private static final Logger LOGGER = LogManager.getLogger((String)"Virtual Mouse");
    private static final VirtualGLFWMouseImplementation INSTANCE = new VirtualGLFWMouseImplementation();
    private final EventQueue event_queue = new EventQueue(34);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(34);
    private final List<XCursor.ImageChunk> chunks = new ArrayList<XCursor.ImageChunk>();
    protected GLFWMouseButtonCallback buttonCallback;
    protected byte[] button_states = new byte[this.getButtonCount()];
    private GLFWCursorPosCallback posCallback;
    private GLFWScrollCallback scrollCallback;
    private GLFWCursorEnterCallback cursorEnterCallback;
    private long windowHandle;
    private boolean grabbed;
    private boolean isInsideWindow;
    private double last_x;
    private double last_y;
    private double accum_dx;
    private double accum_dy;
    private double accum_dz;
    private double virt_offset_x;
    private double virt_offset_y;
    private int current;
    private int[] images = new int[]{-1};
    private long animationTime;
    private boolean virtual;
    private boolean created;

    public static VirtualGLFWMouseImplementation getInstance() {
        return INSTANCE;
    }

    public static void render() {
        VirtualGLFWMouseImplementation.getInstance().draw();
    }

    @Override
    public void createMouse() {
        this.windowHandle = Display.getHandle();
        if (GLFW.glfwRawMouseMotionSupported() && !Mouse.getPrivilegedBoolean("org.lwjgl.input.Mouse.disableRawInput")) {
            GLFW.glfwSetInputMode((long)this.windowHandle, (int)208901, (int)1);
        }
        this.buttonCallback = GLFWMouseButtonCallback.create((window, button, action, mods) -> {
            byte state = action == 1 ? (byte)1 : (byte)0;
            this.putMouseEvent((byte)button, state, 0, System.nanoTime());
            if (button < this.button_states.length) {
                this.button_states[button] = state;
            }
        });
        this.posCallback = GLFWCursorPosCallback.create((window, xpos, ypos) -> {
            VirtualGLFWMouseImplementation virtualGLFWMouseImplementation = this;
            synchronized (virtualGLFWMouseImplementation) {
                if (!this.created) {
                    this.created = true;
                    this.setup();
                }
            }
            int x = (int)xpos;
            int y = Display.getHeight() - (int)ypos;
            double dx = (double)x - this.last_x;
            double dy = (double)y - this.last_y;
            if (dx != 0.0 || dy != 0.0) {
                this.accum_dx += dx;
                this.accum_dy += dy;
                this.last_x = x;
                this.last_y = y;
                if (this.virtual) {
                    while (this.getX() <= 0.0) {
                        this.virt_offset_x += 1.0;
                    }
                    while (this.getX() > (double)Display.getWidth()) {
                        this.virt_offset_x -= 1.0;
                    }
                    while (this.getY() < 0.0) {
                        this.virt_offset_y += 1.0;
                    }
                    while (this.getY() > (double)(Display.getHeight() - 1)) {
                        this.virt_offset_y -= 1.0;
                    }
                }
                long nanos = System.nanoTime();
                if (this.grabbed) {
                    this.putMouseEventWithCoords((byte)-1, (byte)0, dx, dy, 0, nanos);
                } else {
                    this.putMouseEventWithCoords((byte)-1, (byte)0, x, y, 0, nanos);
                }
            }
        });
        this.scrollCallback = GLFWScrollCallback.create((window, xoffset, yoffset) -> {
            this.accum_dz += yoffset;
            this.putMouseEvent((byte)-1, (byte)0, (int)yoffset, System.nanoTime());
        });
        this.cursorEnterCallback = GLFWCursorEnterCallback.create((window, entered) -> {
            this.isInsideWindow = entered;
        });
        GLFW.glfwSetMouseButtonCallback((long)this.windowHandle, (GLFWMouseButtonCallbackI)this.buttonCallback);
        GLFW.glfwSetCursorPosCallback((long)this.windowHandle, (GLFWCursorPosCallbackI)this.posCallback);
        GLFW.glfwSetScrollCallback((long)this.windowHandle, (GLFWScrollCallbackI)this.scrollCallback);
        GLFW.glfwSetCursorEnterCallback((long)this.windowHandle, (GLFWCursorEnterCallbackI)this.cursorEnterCallback);
        this.created = false;
    }

    private boolean mayVirtualize() {
        return C_8105098.m_0408063().f_4601986 != null;
    }

    private boolean isValidScreen() {
        C_3020744 s = C_8105098.m_0408063().f_0723335;
        return s instanceof C_9639106 || s instanceof C_7669754 || s instanceof C_2966580;
    }

    private void setup() {
        this.virt_offset_x = 0.0;
        this.virt_offset_y = 0.0;
        this.loadCursor();
    }

    protected void putMouseEvent(byte button, byte state, int dz, long nanos) {
        if (this.grabbed) {
            this.putMouseEventWithCoords(button, state, 0.0, 0.0, dz, nanos);
        } else {
            this.putMouseEventWithCoords(button, state, this.getX(), this.getY(), dz, nanos);
        }
    }

    protected void putMouseEventWithCoords(byte button, byte state, double coord1, double coord2, int dz, long nanos) {
        this.tmp_event.clear();
        this.tmp_event.put(button).put(state).putDouble(coord1).putDouble(coord2).putDouble(dz).putLong(nanos);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
    }

    @Override
    public void destroyMouse() {
        this.buttonCallback.free();
        this.posCallback.free();
        this.scrollCallback.free();
        this.cursorEnterCallback.free();
        if (this.images[0] != 0) {
            for (int i : this.images) {
                C_3754158.m_1310033((int)i);
            }
            this.images = new int[]{-1};
        }
    }

    private void reset() {
        this.event_queue.clearEvents();
        this.accum_dy = 0.0;
        this.accum_dx = 0.0;
    }

    @Override
    public void pollMouse(DoubleBuffer coord_buffer, ByteBuffer buttons_buffer) {
        if (this.grabbed) {
            coord_buffer.put(0, this.accum_dx);
            coord_buffer.put(1, this.accum_dy);
        } else {
            coord_buffer.put(0, this.getX());
            coord_buffer.put(1, this.getY());
        }
        coord_buffer.put(2, this.accum_dz);
        this.accum_dz = 0.0;
        this.accum_dy = 0.0;
        this.accum_dx = 0.0;
        for (int i = 0; i < this.button_states.length; ++i) {
            buttons_buffer.put(i, this.button_states[i]);
        }
    }

    @Override
    public void readMouse(ByteBuffer readBuffer) {
        this.event_queue.copyEvents(readBuffer);
    }

    @Override
    public void setCursorPosition(double x, double y) {
        this.virt_offset_y = y - this.last_y;
        this.virt_offset_x = x - this.last_x;
    }

    @Override
    public void grabMouse(boolean grab) {
        if (grab) {
            GLFW.glfwSetInputMode((long)this.windowHandle, (int)208897, (int)212995);
            this.virtual = false;
        } else if (this.isValidScreen() && this.mayVirtualize()) {
            this.virtual = true;
        } else {
            GLFW.glfwSetInputMode((long)this.windowHandle, (int)208897, (int)212993);
        }
        this.grabbed = grab;
        this.reset();
    }

    @Override
    public boolean hasWheel() {
        return true;
    }

    @Override
    public int getButtonCount() {
        return 8;
    }

    @Override
    public boolean isInsideWindow() {
        return this.isInsideWindow;
    }

    private void draw() {
        if (this.virtual && this.images[0] != -1) {
            C_3754158.m_7547086();
            C_3754158.m_2754767();
            C_3754158.m_9671730();
            C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
            C_3754158.m_2768959((int)this.images[this.current]);
            float scale = new C_7799337(C_8105098.m_0408063()).m_8052133();
            double x = this.getX();
            double y = this.getY();
            this.drawTexture((x - (double)this.getCurrent().xhot) / (double)scale, ((double)Display.getHeight() - y - (double)this.getCurrent().yhot) / (double)scale, (float)this.getCurrent().width / scale, (float)this.getCurrent().height / scale, (float)this.getCurrent().width / scale, (float)this.getCurrent().height / scale);
            this.advanceAnimation();
        }
    }

    private void drawTexture(double x, double y, double width, double height, double textureWidth, double textureHeight) {
        double n = 1.0 / textureWidth;
        double o = 1.0 / textureHeight;
        double z = 1000.0;
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        bufferBuilder.m_0421390(7, C_4461663.f_9223614);
        bufferBuilder.m_3299851(x, y + height, z).m_4749889(0.0, height * o).m_4365807();
        bufferBuilder.m_3299851(x + width, y + height, z).m_4749889(width * n, height * o).m_4365807();
        bufferBuilder.m_3299851(x + width, y, z).m_4749889(width * n, 0.0).m_4365807();
        bufferBuilder.m_3299851(x, y, z).m_4749889(0.0, 0.0).m_4365807();
        tessellator.m_8222644();
    }

    private void advanceAnimation() {
        if (this.images.length > 1 && (this.animationTime == 0L || System.currentTimeMillis() - this.animationTime > this.getCurrent().delay)) {
            this.animationTime = System.currentTimeMillis();
            ++this.current;
            if (this.current >= this.images.length) {
                this.current = 0;
            }
        }
    }

    private XCursor.ImageChunk getCurrent() {
        return this.chunks.get(this.current);
    }

    private void loadCursor() {
        XCursor cursor = SystemCursor.load();
        if (Boolean.getBoolean("virtual_mouse.export")) {
            cursor.export();
        }
        this.chunks.clear();
        for (XCursor.Chunk chunk : cursor.chunks) {
            XCursor.ImageChunk c;
            if (!(chunk instanceof XCursor.ImageChunk) || (c = (XCursor.ImageChunk)chunk).getSubtype() != (long)XDGPathResolver.getCursorSize()) continue;
            this.chunks.add(c);
        }
        this.current = 0;
        this.images = new int[this.chunks.size()];
        for (int i = 0; i < this.images.length; ++i) {
            int id;
            XCursor.ImageChunk c = this.chunks.get(i);
            this.images[i] = id = C_0979881.m_6984163();
            C_0979881.m_6605934((int)id, (int)((int)c.width), (int)((int)c.height));
            C_0979881.m_5404645((int)id, (int[])c.getImage(), (int)((int)c.width), (int)((int)c.height));
        }
    }

    private double getX() {
        return this.virtual ? this.last_x + this.virt_offset_x : this.last_x;
    }

    private double getY() {
        return this.virtual ? this.last_y + this.virt_offset_y : this.last_y;
    }

    private static class XCursor {
        private final String magic;
        private final long headerLength;
        private final long fileVersion;
        private final long toCEntryCount;
        private final TableOfContents[] toC;
        private final Chunk[] chunks;

        public static XCursor parse(ByteBuffer buf) {
            String magic = XCursor.getString(buf, 4);
            if (!"Xcur".equals(magic)) {
                throw new IllegalArgumentException("Not an Xcursor file! Magic: " + magic);
            }
            long headerLength = XCursor.getInt(buf);
            long version = XCursor.getInt(buf);
            long ntoc = XCursor.getInt(buf);
            TableOfContents[] toc = new TableOfContents[(int)ntoc];
            Chunk[] chunks = new Chunk[(int)ntoc];
            int i = 0;
            while ((long)i < ntoc) {
                TableOfContents table;
                toc[i] = table = new TableOfContents(XCursor.getInt(buf), XCursor.getInt(buf), XCursor.getInt(buf));
                chunks[i] = XCursor.parseChunk(buf, table);
                ++i;
            }
            return new XCursor(magic, headerLength, version, ntoc, toc, chunks);
        }

        private static Chunk parseChunk(ByteBuffer buf, TableOfContents table) {
            int pos = buf.position();
            buf.position((int)table.position);
            Chunk c = switch ((int)table.type) {
                case -131071 -> XCursor.parseComment(buf, table);
                case -196606 -> XCursor.parseImage(buf, table);
                default -> throw new IllegalArgumentException("Unrecognized type: " + table.type);
            };
            buf.position(pos);
            return c;
        }

        private static Chunk parseImage(ByteBuffer buf, TableOfContents table) {
            long size = XCursor.getInt(buf);
            if (size != 36L) {
                throw new IllegalArgumentException("not an image chunk! size != 36: " + size);
            }
            long type = XCursor.getInt(buf);
            if (type != 4294770690L || type != table.type) {
                throw new IllegalArgumentException("not an image chunk! type != image: " + type);
            }
            long subtype = XCursor.getInt(buf);
            if (subtype != table.subtype) {
                throw new IllegalArgumentException("not an image chunk! subtype != table.subtype: " + subtype);
            }
            long version = XCursor.getInt(buf);
            long width = XCursor.getInt(buf);
            if (width > 2047L) {
                throw new IllegalArgumentException("image too large! width > 0x7ff: " + width);
            }
            long height = XCursor.getInt(buf);
            if (height > 2047L) {
                throw new IllegalArgumentException("image too large! height > 0x7ff: " + height);
            }
            long xhot = XCursor.getInt(buf);
            if (xhot > width) {
                throw new IllegalArgumentException("xhot outside image!: " + xhot);
            }
            long yhot = XCursor.getInt(buf);
            if (yhot > height) {
                throw new IllegalArgumentException("yhot outside image!: " + yhot);
            }
            long delay = XCursor.getInt(buf);
            long[] pixels = new long[(int)(width * height)];
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = XCursor.getInt(buf);
            }
            return new ImageChunk(size, type, subtype, version, width, height, xhot, yhot, delay, pixels);
        }

        private static Chunk parseComment(ByteBuffer buf, TableOfContents table) {
            long size = XCursor.getInt(buf);
            if (size != 20L) {
                throw new IllegalArgumentException("not a comment chunk! size != 20: " + size);
            }
            long type = XCursor.getInt(buf);
            if (type != 4294836225L || type != table.type) {
                throw new IllegalArgumentException("not a comment chunk! type != comment: " + type);
            }
            long subtype = XCursor.getInt(buf);
            if (subtype != table.subtype) {
                throw new IllegalArgumentException("not a comment chunk! subtype != table.subtype: " + subtype);
            }
            long version = XCursor.getInt(buf);
            long commentLength = XCursor.getInt(buf);
            String comment = XCursor.getString(buf, (int)commentLength);
            return new CommentChunk(size, type, subtype, version, commentLength, comment);
        }

        private static long getInt(ByteBuffer buf) {
            return XCursor.readUnsignedInteger(buf).longValue();
        }

        private static BigInteger readUnsignedInteger(ByteBuffer buffer) {
            return new BigInteger(1, XCursor.readBytes(buffer));
        }

        private static byte[] readBytes(ByteBuffer buffer) {
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytes[3 - i] = buffer.get();
            }
            return bytes;
        }

        private static String getString(ByteBuffer buf, int length) {
            byte[] data = new byte[length];
            for (int i = 0; i < length; ++i) {
                data[i] = buf.get();
            }
            return new String(data, StandardCharsets.UTF_8);
        }

        public void export() {
            Path dir = Paths.get("cursors", new String[0]);
            try {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to create clean export directory, export will likely fail!", (Throwable)e);
            }
            LOGGER.info("Exporting chunks..");
            for (Chunk c : this.chunks) {
                c.export();
            }
        }

        @Generated
        public XCursor(String magic, long headerLength, long fileVersion, long toCEntryCount, TableOfContents[] toC, Chunk[] chunks) {
            this.magic = magic;
            this.headerLength = headerLength;
            this.fileVersion = fileVersion;
            this.toCEntryCount = toCEntryCount;
            this.toC = toC;
            this.chunks = chunks;
        }

        @Generated
        public String getMagic() {
            return this.magic;
        }

        @Generated
        public long getHeaderLength() {
            return this.headerLength;
        }

        @Generated
        public long getFileVersion() {
            return this.fileVersion;
        }

        @Generated
        public long getToCEntryCount() {
            return this.toCEntryCount;
        }

        @Generated
        public TableOfContents[] getToC() {
            return this.toC;
        }

        @Generated
        public Chunk[] getChunks() {
            return this.chunks;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XCursor)) {
                return false;
            }
            XCursor other = (XCursor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeaderLength() != other.getHeaderLength()) {
                return false;
            }
            if (this.getFileVersion() != other.getFileVersion()) {
                return false;
            }
            if (this.getToCEntryCount() != other.getToCEntryCount()) {
                return false;
            }
            String this$magic = this.getMagic();
            String other$magic = other.getMagic();
            if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getToC(), other.getToC())) {
                return false;
            }
            return Arrays.deepEquals(this.getChunks(), other.getChunks());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof XCursor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $headerLength = this.getHeaderLength();
            result = result * 59 + (int)($headerLength >>> 32 ^ $headerLength);
            long $fileVersion = this.getFileVersion();
            result = result * 59 + (int)($fileVersion >>> 32 ^ $fileVersion);
            long $toCEntryCount = this.getToCEntryCount();
            result = result * 59 + (int)($toCEntryCount >>> 32 ^ $toCEntryCount);
            String $magic = this.getMagic();
            result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getToC());
            result = result * 59 + Arrays.deepHashCode(this.getChunks());
            return result;
        }

        @Generated
        public String toString() {
            return "VirtualGLFWMouseImplementation.XCursor(magic=" + this.getMagic() + ", headerLength=" + this.getHeaderLength() + ", fileVersion=" + this.getFileVersion() + ", toCEntryCount=" + this.getToCEntryCount() + ", toC=" + Arrays.deepToString(this.getToC()) + ", chunks=" + Arrays.deepToString(this.getChunks()) + ")";
        }

        private static class TableOfContents {
            private final long type;
            private final long subtype;
            private final long position;

            @Generated
            public TableOfContents(long type, long subtype, long position) {
                this.type = type;
                this.subtype = subtype;
                this.position = position;
            }

            @Generated
            public long getType() {
                return this.type;
            }

            @Generated
            public long getSubtype() {
                return this.subtype;
            }

            @Generated
            public long getPosition() {
                return this.position;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TableOfContents)) {
                    return false;
                }
                TableOfContents other = (TableOfContents)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getType() != other.getType()) {
                    return false;
                }
                if (this.getSubtype() != other.getSubtype()) {
                    return false;
                }
                return this.getPosition() == other.getPosition();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TableOfContents;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $type = this.getType();
                result = result * 59 + (int)($type >>> 32 ^ $type);
                long $subtype = this.getSubtype();
                result = result * 59 + (int)($subtype >>> 32 ^ $subtype);
                long $position = this.getPosition();
                result = result * 59 + (int)($position >>> 32 ^ $position);
                return result;
            }

            @Generated
            public String toString() {
                return "VirtualGLFWMouseImplementation.XCursor.TableOfContents(type=" + this.getType() + ", subtype=" + this.getSubtype() + ", position=" + this.getPosition() + ")";
            }
        }

        private static abstract class Chunk {
            private final long length;
            private final long type;
            private final long subtype;
            private final long version;

            public Chunk(long length, long type, long subtype, long version) {
                this.length = length;
                this.type = type;
                this.subtype = subtype;
                this.version = version;
            }

            public abstract void export();

            @Generated
            public long getLength() {
                return this.length;
            }

            @Generated
            public long getType() {
                return this.type;
            }

            @Generated
            public long getSubtype() {
                return this.subtype;
            }

            @Generated
            public long getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Chunk)) {
                    return false;
                }
                Chunk other = (Chunk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getLength() != other.getLength()) {
                    return false;
                }
                if (this.getType() != other.getType()) {
                    return false;
                }
                if (this.getSubtype() != other.getSubtype()) {
                    return false;
                }
                return this.getVersion() == other.getVersion();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Chunk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $length = this.getLength();
                result = result * 59 + (int)($length >>> 32 ^ $length);
                long $type = this.getType();
                result = result * 59 + (int)($type >>> 32 ^ $type);
                long $subtype = this.getSubtype();
                result = result * 59 + (int)($subtype >>> 32 ^ $subtype);
                long $version = this.getVersion();
                result = result * 59 + (int)($version >>> 32 ^ $version);
                return result;
            }

            @Generated
            public String toString() {
                return "VirtualGLFWMouseImplementation.XCursor.Chunk(length=" + this.getLength() + ", type=" + this.getType() + ", subtype=" + this.getSubtype() + ", version=" + this.getVersion() + ")";
            }
        }

        private static class ImageChunk
        extends Chunk {
            private final long width;
            private final long height;
            private final long xhot;
            private final long yhot;
            private final long delay;
            private final long[] pixels;

            public ImageChunk(long length, long type, long subtype, long version, long width, long height, long xhot, long yhot, long delay, long[] pixels) {
                super(length, type, subtype, version);
                this.width = width;
                this.height = height;
                this.xhot = xhot;
                this.yhot = yhot;
                this.delay = delay;
                this.pixels = pixels;
            }

            public int[] getImage() {
                int[] data = new int[this.pixels.length];
                for (int i = 0; i < this.pixels.length; ++i) {
                    data[i] = (int)this.pixels[i];
                }
                return data;
            }

            @Override
            public void export() {
                String imageName;
                BufferedImage im = new BufferedImage((int)this.width, (int)this.height, 2);
                int[] data = this.getImage();
                for (int i = 0; i < data.length; ++i) {
                    im.setRGB((int)((long)i % this.width), (int)((long)i / this.height), data[i]);
                }
                ArrayList<Object> lines = new ArrayList<Object>();
                lines.add("[Sizes]");
                lines.add("Cursor: " + this.getSubtype() + "x" + this.getSubtype());
                lines.add("Image: " + this.width + "x" + this.height);
                lines.add("[Hotspots]");
                lines.add("X: " + this.xhot);
                lines.add("Y: " + this.yhot);
                lines.add("[Delay]");
                lines.add("" + this.delay);
                String name = imageName = this.getSubtype() + "x" + this.getSubtype();
                if (this.delay != 0L) {
                    int i = 0;
                    name = imageName + "_" + i;
                    while (new File("cursors", name + ".png").exists()) {
                        name = imageName + "_" + ++i;
                    }
                }
                String cursor = this.getSubtype() + " " + this.xhot + " " + this.yhot + " " + name + ".png";
                Path cursorFile = Paths.get("cursors", "cursor.cursor");
                if (this.delay != 0L) {
                    cursor = cursor + " " + this.delay;
                    if (Files.exists(cursorFile, new LinkOption[0])) {
                        cursor = "\n" + cursor;
                    }
                }
                try {
                    ImageIO.write((RenderedImage)im, "png", new File("cursors", name + ".png"));
                    Files.write(Paths.get("cursors", name + ".txt"), lines, StandardOpenOption.CREATE);
                    Files.write(cursorFile, cursor.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    LOGGER.warn("Image export failed!", (Throwable)e);
                }
            }

            @Generated
            public long getWidth() {
                return this.width;
            }

            @Generated
            public long getHeight() {
                return this.height;
            }

            @Generated
            public long getXhot() {
                return this.xhot;
            }

            @Generated
            public long getYhot() {
                return this.yhot;
            }

            @Generated
            public long getDelay() {
                return this.delay;
            }

            @Generated
            public long[] getPixels() {
                return this.pixels;
            }

            @Override
            @Generated
            public String toString() {
                return "VirtualGLFWMouseImplementation.XCursor.ImageChunk(width=" + this.getWidth() + ", height=" + this.getHeight() + ", xhot=" + this.getXhot() + ", yhot=" + this.getYhot() + ", delay=" + this.getDelay() + ", pixels=" + Arrays.toString(this.getPixels()) + ")";
            }

            @Override
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ImageChunk)) {
                    return false;
                }
                ImageChunk other = (ImageChunk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                if (this.getWidth() != other.getWidth()) {
                    return false;
                }
                if (this.getHeight() != other.getHeight()) {
                    return false;
                }
                if (this.getXhot() != other.getXhot()) {
                    return false;
                }
                if (this.getYhot() != other.getYhot()) {
                    return false;
                }
                if (this.getDelay() != other.getDelay()) {
                    return false;
                }
                return Arrays.equals(this.getPixels(), other.getPixels());
            }

            @Override
            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ImageChunk;
            }

            @Override
            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                long $width = this.getWidth();
                result = result * 59 + (int)($width >>> 32 ^ $width);
                long $height = this.getHeight();
                result = result * 59 + (int)($height >>> 32 ^ $height);
                long $xhot = this.getXhot();
                result = result * 59 + (int)($xhot >>> 32 ^ $xhot);
                long $yhot = this.getYhot();
                result = result * 59 + (int)($yhot >>> 32 ^ $yhot);
                long $delay = this.getDelay();
                result = result * 59 + (int)($delay >>> 32 ^ $delay);
                result = result * 59 + Arrays.hashCode(this.getPixels());
                return result;
            }
        }

        private static class CommentChunk
        extends Chunk {
            private final long length;
            private final String comment;

            public CommentChunk(long length, long type, long subtype, long version, long commentLength, String comment) {
                super(length, type, subtype, version);
                this.length = commentLength;
                this.comment = comment;
            }

            @Override
            public void export() {
                String name = this.getSubtype() == 1L ? "COPYRIGHT" : (this.getSubtype() == 2L ? "LICENSE" : "COMMENT");
                try {
                    Files.write(Paths.get("cursors", name), this.comment.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                }
                catch (IOException e) {
                    LOGGER.warn("Image export failed!", (Throwable)e);
                }
            }

            @Override
            @Generated
            public long getLength() {
                return this.length;
            }

            @Generated
            public String getComment() {
                return this.comment;
            }

            @Override
            @Generated
            public String toString() {
                return "VirtualGLFWMouseImplementation.XCursor.CommentChunk(length=" + this.getLength() + ", comment=" + this.getComment() + ")";
            }

            @Override
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CommentChunk)) {
                    return false;
                }
                CommentChunk other = (CommentChunk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                if (this.getLength() != other.getLength()) {
                    return false;
                }
                String this$comment = this.getComment();
                String other$comment = other.getComment();
                return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
            }

            @Override
            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CommentChunk;
            }

            @Override
            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                long $length = this.getLength();
                result = result * 59 + (int)($length >>> 32 ^ $length);
                String $comment = this.getComment();
                result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
                return result;
            }
        }
    }

    private static class SystemCursor {
        private static final SystemCursor INSTANCE = new SystemCursor();

        private SystemCursor() {
        }

        public static XCursor load() {
            try {
                byte[] c = IOUtils.toByteArray((InputStream)INSTANCE.getArrowCursor());
                ByteBuffer buf = ByteBuffer.wrap(c);
                return XCursor.parse(buf);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load cursor texture!", e);
            }
        }

        private InputStream getArrowCursor() throws IOException {
            Path theme = XDGPathResolver.getIconTheme("cursors/left_ptr");
            if (theme != null) {
                LOGGER.info("Loading system cursor: " + String.valueOf(theme));
                return Files.newInputStream(theme, new OpenOption[0]);
            }
            LOGGER.info("Falling back to packaged cursor");
            try {
                return C_8105098.m_0408063().m_3739907().m_5942034(new C_0561170("virtual_cursor", "default")).m_3098790();
            }
            catch (IOException iOException) {
                return this.getClass().getResourceAsStream("/assets/virtual_cursor/default");
            }
        }
    }
}

