/*
 * Decompiled with CFR 0.152.
 */
package io.github.moehreag.legacylwjgl3.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class XDGPathResolver {
    private static Path getHome() {
        String home = System.getenv().getOrDefault("HOME", System.getProperty("user.home"));
        if (home == null || home.isEmpty()) {
            throw new IllegalStateException("could not resolve user home");
        }
        return Paths.get(home, new String[0]);
    }

    public static Path getUserDataLocation() {
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome == null || xdgDataHome.isEmpty()) {
            return XDGPathResolver.getHome().resolve(".local/share/");
        }
        return Paths.get(xdgDataHome, new String[0]);
    }

    public static List<Path> getIconThemeLocations() {
        Path userShare = XDGPathResolver.getUserDataLocation().resolve("icons");
        Path homeIcons = XDGPathResolver.getHome().resolve(".icons");
        Path systemIcons = Paths.get("/usr/share/icons", new String[0]);
        return ImmutableList.of((Object)userShare, (Object)homeIcons, (Object)systemIcons);
    }

    public static Path getIconTheme(String icon) {
        String themeName;
        ProcessBuilder builder = new ProcessBuilder("gsettings", "get", "org.gnome.desktop.interface", "cursor-theme");
        try {
            Process p = builder.start();
            themeName = IOUtils.toString((InputStream)p.getInputStream()).split("'")[1];
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            themeName = "default";
        }
        return XDGPathResolver.findInThemes(themeName, icon);
    }

    private static Path findInThemes(String themeName, String icon) {
        Path themePath = XDGPathResolver.getThemePath(themeName);
        Path iconPath = themePath.resolve(icon);
        if (Files.exists(iconPath, new LinkOption[0])) {
            return iconPath;
        }
        Path themeIndex = themePath.resolve("index.theme");
        if (Files.exists(themeIndex, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(themeIndex, StandardCharsets.UTF_8);
                boolean iconThemeFound = false;
                for (String s : lines) {
                    String[] parts;
                    if ("[Icon Theme]".equals(s)) {
                        iconThemeFound = true;
                    }
                    if (!iconThemeFound || s.startsWith("#") || !"Inherits".equals((parts = s.split("=", 2))[0])) continue;
                    return XDGPathResolver.findInThemes(parts[1], icon);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Path getThemePath(String name) {
        for (Path p : XDGPathResolver.getIconThemeLocations()) {
            Path theme = p.resolve(name);
            if (!Files.exists(theme, new LinkOption[0])) continue;
            return theme;
        }
        if ("default".equals(name)) {
            return Paths.get("usr", "share", "icons", "default");
        }
        return XDGPathResolver.getThemePath("default");
    }

    public static int getCursorSize() {
        int size;
        ProcessBuilder builder = new ProcessBuilder("gsettings", "get", "org.gnome.desktop.interface", "cursor-size");
        try {
            Process p = builder.start();
            size = Integer.parseInt(IOUtils.toString((InputStream)p.getInputStream()).split("\n")[0]);
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            size = 24;
        }
        return size;
    }
}

