/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import io.github.moehreag.legacylwjgl3.DesktopFileInjector;
import io.github.moehreag.legacylwjgl3.LegacyLWJGL3;
import io.github.moehreag.legacylwjgl3.LegacyLWJGL3ScreenEx;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;
import org.lwjgl.system.MemoryStack;

public final class Display {
    @NotNull
    private static String title = "";
    private static long handle = -1L;
    private static boolean resizable;
    @NotNull
    private static DisplayMode displayMode;
    private static int width;
    private static int height;
    private static int framebufferWidth;
    private static int framebufferHeight;
    private static int windowedWidth;
    private static int windowedHeight;
    private static int x;
    private static int windowedX;
    private static int y;
    private static int windowedY;
    private static boolean window_resized;
    private static boolean minimized;
    private static boolean iconified;
    @Nullable
    private static ByteBuffer[] cached_icons;
    private static boolean focused;

    private Display() {
    }

    @NotNull
    public static String getTitle() {
        return title;
    }

    public static void setTitle(@NotNull String title) {
        Display.title = title;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle((long)handle, (CharSequence)title);
        }
    }

    public static long getHandle() {
        return handle;
    }

    public static void setHandle(long handle) {
        Display.handle = handle;
    }

    @NotNull
    public static DisplayMode getDisplayMode() {
        return displayMode;
    }

    public static void setDisplayMode(@NotNull DisplayMode mode) {
        displayMode = mode;
    }

    public static int getWidth() {
        return framebufferWidth;
    }

    public static void setWidth(int width) {
        framebufferWidth = width;
    }

    public static int getHeight() {
        return framebufferHeight;
    }

    public static void setHeight(int height) {
        framebufferHeight = height;
    }

    public static void setScreenWidth(int width) {
        Display.width = width;
    }

    public static int getScreenWidth() {
        return width;
    }

    public static void setScreenHeight(int height) {
        Display.height = height;
    }

    public static int getScreenHeight() {
        return height;
    }

    @Nullable
    public static DisplayMode getDesktopDisplayMode() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)primaryMonitor);
        if (mode == null) {
            return Arrays.stream(Display.getAvailableDisplayModes()).max(Comparator.comparingInt(d -> d.getWidth() * d.getHeight())).orElse(null);
        }
        return new DisplayMode(mode.width(), mode.height(), mode.redBits() + mode.greenBits() + mode.blueBits(), mode.refreshRate());
    }

    public static int setIcon(@NotNull ByteBuffer[] icons) {
        if (GLFW.glfwGetPlatform() == 393219) {
            return DesktopFileInjector.setIcon(icons);
        }
        if (!Arrays.equals(cached_icons, icons)) {
            cached_icons = (ByteBuffer[])Arrays.stream(icons).map(buf -> {
                ByteBuffer copy = ByteBuffer.allocate(buf.capacity());
                int old_pos = buf.position();
                copy.put((ByteBuffer)buf);
                buf.position(old_pos);
                copy.flip();
                return copy;
            }).toArray(ByteBuffer[]::new);
        }
        if (Display.isCreated() && GLFW.glfwGetPlatform() != 393218) {
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)icons.length, (MemoryStack)memoryStack);
                for (int j = 0; j < icons.length; ++j) {
                    ByteBuffer buf2 = icons[j];
                    int size = (int)Math.sqrt((float)buf2.limit() / 4.0f);
                    ByteBuffer byteBuffer = memoryStack.malloc(buf2.limit()).put(buf2).flip();
                    ((GLFWImage.Buffer)buffer.position(j)).width(size).height(size).pixels(byteBuffer);
                }
                GLFW.glfwSetWindowIcon((long)handle, (GLFWImage.Buffer)buffer);
            }
            return 1;
        }
        return 0;
    }

    public static void update() {
        window_resized = false;
        GLFW.glfwPollEvents();
        if (Mouse.isCreated()) {
            Mouse.poll();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
        GLFW.glfwSwapBuffers((long)handle);
    }

    public static void create(@NotNull PixelFormat pixelFormat) throws LWJGLException {
        int[] yBox;
        int[] xBox;
        windowedWidth = width = displayMode.getWidth();
        windowedHeight = height = displayMode.getHeight();
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        GLFW.glfwDefaultWindowHints();
        if (GLFW.glfwGetPlatform() == 393219) {
            DesktopFileInjector.inject();
            GLFW.glfwWindowHintString((int)155649, (CharSequence)"com.mojang.minecraft");
        }
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        if (GLFW.glfwGetPlatform() != 393218) {
            GLFW.glfwWindowHint((int)139266, (int)3);
            GLFW.glfwWindowHint((int)139267, (int)2);
            GLFW.glfwWindowHint((int)139272, (int)204802);
        }
        GLFW.glfwWindowHint((int)135172, (int)pixelFormat.getAlphaBits());
        GLFW.glfwWindowHint((int)135173, (int)pixelFormat.getDepthBits());
        GLFW.glfwWindowHint((int)135174, (int)pixelFormat.getStencilBits());
        GLFW.glfwWindowHint((int)135180, (int)(pixelFormat.isStereo() ? 1 : 0));
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        handle = GLFW.glfwCreateWindow((int)displayMode.getWidth(), (int)displayMode.getHeight(), (CharSequence)title, (long)0L, (long)0L);
        GLFW.glfwMakeContextCurrent((long)handle);
        GL.createCapabilities();
        if (primaryMonitor != 0L) {
            GLFWVidMode mode = GLFW.glfwGetVideoMode((long)primaryMonitor);
            int[] xBox2 = new int[1];
            int[] yBox2 = new int[1];
            GLFW.glfwGetMonitorPos((long)primaryMonitor, (int[])xBox2, (int[])yBox2);
            windowedX = x = xBox2[0] + mode.width() / 2 - width / 2;
            windowedY = y = yBox2[0] + mode.height() / 2 - height / 2;
        } else if (GLFW.glfwGetPlatform() != 393219) {
            xBox = new int[1];
            yBox = new int[1];
            GLFW.glfwGetWindowPos((long)handle, (int[])xBox, (int[])yBox);
            windowedX = x = xBox[0];
            windowedY = y = yBox[0];
        }
        Display.setFullscreen(false);
        xBox = new int[1];
        yBox = new int[1];
        GLFW.glfwGetFramebufferSize((long)handle, (int[])xBox, (int[])yBox);
        framebufferWidth = xBox[0] <= 0 ? 1 : xBox[0];
        framebufferHeight = yBox[0] <= 0 ? 1 : yBox[0];
        GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)GLFWWindowSizeCallback.create(Display::resizeCallback));
        GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)GLFWFramebufferSizeCallback.create(Display::onFramebufferResize));
        GLFW.glfwSetWindowFocusCallback((long)handle, (window, focused1) -> {
            if (window == handle) {
                focused = focused1;
            }
        });
        GLFW.glfwSetWindowIconifyCallback((long)handle, (GLFWWindowIconifyCallbackI)GLFWWindowIconifyCallback.create(Display::onIconify));
        GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)GLFWWindowPosCallback.create((window, xpos, ypos) -> {
            x = xpos;
            y = ypos;
        }));
        GLFW.glfwSetDropCallback((long)handle, (GLFWDropCallbackI)GLFWDropCallback.create((window, count, names) -> {
            List<Path> dropped = IntStream.range(0, count).mapToObj(i -> GLFWDropCallback.getName((long)names, (int)i)).map(s -> {
                try {
                    return Path.of(s, new String[0]);
                }
                catch (InvalidPathException e) {
                    LegacyLWJGL3.LOGGER.warn("Failed to parse dropped path! '{}'", new Object[]{s, e});
                    return null;
                }
            }).filter(Objects::nonNull).toList();
            if (!dropped.isEmpty()) {
                LegacyLWJGL3ScreenEx.handleFileDrop(dropped);
            }
        }));
        Mouse.create();
        Keyboard.create();
        GLFW.glfwShowWindow((long)handle);
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        }
    }

    private static void onIconify(long window, boolean iconified) {
        Display.iconified = iconified;
    }

    private static void onFramebufferResize(long window, int framebufferWidth, int framebufferHeight) {
        if (window != handle) {
            return;
        }
        int prevWidth = Display.framebufferWidth;
        int prevHeight = Display.framebufferHeight;
        if (framebufferWidth != 0 && framebufferHeight != 0) {
            minimized = false;
            Display.framebufferWidth = framebufferWidth;
            Display.framebufferHeight = framebufferHeight;
            if (Display.framebufferWidth != prevWidth || Display.framebufferHeight != prevHeight) {
                window_resized = true;
            }
        } else {
            minimized = true;
        }
    }

    public static void setFullscreen(boolean fullscreen) {
        try {
            boolean isFullscreen;
            boolean bl = isFullscreen = GLFW.glfwGetWindowMonitor((long)handle) != 0L;
            if (fullscreen) {
                long monitor = Display.getPrimaryMonitor();
                if (monitor == 0L) {
                    LegacyLWJGL3.LOGGER.warn("Failed to find monitor for fullscreen");
                    return;
                }
                if (!isFullscreen) {
                    windowedX = x;
                    windowedY = y;
                    windowedWidth = width;
                    windowedHeight = height;
                }
                x = 0;
                y = 0;
                GLFWVidMode mode = GLFW.glfwGetVideoMode((long)monitor);
                width = mode.width();
                height = mode.height();
                GLFW.glfwSetWindowMonitor((long)Display.getHandle(), (long)monitor, (int)x, (int)y, (int)width, (int)height, (int)mode.refreshRate());
            } else {
                x = windowedX;
                y = windowedY;
                width = windowedWidth;
                height = windowedHeight;
                GLFW.glfwSetWindowMonitor((long)Display.getHandle(), (long)0L, (int)x, (int)y, (int)width, (int)height, (int)-1);
            }
            window_resized = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static int clamp(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }

    private static long getPrimaryMonitor() {
        long l = GLFW.glfwGetWindowMonitor((long)handle);
        if (l != 0L) {
            return l;
        }
        int xStart = x;
        int xEnd = xStart + Display.getScreenWidth();
        int yStart = y;
        int yEnd = yStart + Display.getScreenHeight();
        int largestArea = -1;
        long monitor = 0L;
        long primary = GLFW.glfwGetPrimaryMonitor();
        PointerBuffer buf = GLFW.glfwGetMonitors();
        if (buf == null) {
            return 0L;
        }
        for (int i = 0; i < buf.limit(); ++i) {
            long monitor2 = buf.get(i);
            int[] posXBox = new int[1];
            int[] posYBox = new int[1];
            GLFW.glfwGetMonitorPos((long)monitor2, (int[])posXBox, (int[])posYBox);
            GLFWVidMode currentMode = GLFW.glfwGetVideoMode((long)monitor2);
            int monitorXStart = posXBox[0];
            int monitorXEnd = monitorXStart + currentMode.width();
            int monitorYStart = posYBox[0];
            int monitorYEnd = monitorYStart + currentMode.height();
            int left = Display.clamp(xStart, monitorXStart, monitorXEnd);
            int right = Display.clamp(xEnd, monitorXStart, monitorXEnd);
            int top = Display.clamp(yStart, monitorYStart, monitorYEnd);
            int bottom = Display.clamp(yEnd, monitorYStart, monitorYEnd);
            int maxWidth = Math.max(0, right - left);
            int maxHeight = Math.max(0, bottom - top);
            int maxArea = maxWidth * maxHeight;
            if (maxArea > largestArea) {
                monitor = monitor2;
                largestArea = maxArea;
                continue;
            }
            if (maxArea != largestArea || primary != monitor2) continue;
            monitor = monitor2;
        }
        return monitor;
    }

    @NotNull
    public static DisplayMode[] getAvailableDisplayModes() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            return new DisplayMode[0];
        }
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes((long)primaryMonitor);
        if (videoModes == null) {
            throw new IllegalStateException("No video modes found");
        }
        return (DisplayMode[])videoModes.stream().map(mode -> new DisplayMode(mode.width(), mode.height(), mode.redBits() + mode.blueBits() + mode.greenBits(), mode.refreshRate())).toArray(DisplayMode[]::new);
    }

    public static void destroy() {
        Callbacks.glfwFreeCallbacks((long)handle);
        GLFWErrorCallback callback = GLFW.glfwSetErrorCallback(null);
        if (callback != null) {
            callback.free();
        }
        GLFW.glfwDestroyWindow((long)handle);
        GLFW.glfwTerminate();
    }

    public static boolean isCreated() {
        return handle != -1L;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)handle);
    }

    public static boolean isActive() {
        return focused;
    }

    public static void setResizable(boolean isResizable) {
        resizable = isResizable;
        if (Display.isCreated()) {
            GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        }
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static void setVSyncEnabled(boolean enabled) {
        if (GLFW.glfwGetCurrentContext() != 0L) {
            GLFW.glfwSwapInterval((int)(enabled ? 1 : 0));
        }
    }

    public static boolean wasResized() {
        return window_resized;
    }

    public static boolean isVisible() {
        return !minimized;
    }

    private static void resizeCallback(long window, int width, int height) {
        if (window == handle) {
            window_resized = true;
            Display.width = width;
            Display.height = height;
        }
    }

    @Generated
    public static int getX() {
        return x;
    }

    @Generated
    public static void setX(int x) {
        Display.x = x;
    }

    @Generated
    public static void setY(int y) {
        Display.y = y;
    }

    @Generated
    public static int getY() {
        return y;
    }

    @Generated
    public static boolean isIconified() {
        return iconified;
    }

    static {
        displayMode = new DisplayMode(640, 480, 24, 60);
        window_resized = true;
        cached_icons = null;
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
    }
}

