/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.pistorder.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import me.fallenbreath.pistorder.impl.PistonActionType;
import me.fallenbreath.pistorder.impl.PistorderDisplay;
import me.fallenbreath.pistorder.impl.TweakerMoreCompact;
import me.fallenbreath.pistorder.mixins.PistonBlockAccessor;
import me.fallenbreath.pistorder.utils.PistorderKeyBinding;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;

public class Pistorder {
    private static final Pistorder INSTANCE = new Pistorder();
    private final Map<Pair<class_1937, class_2338>, PistorderDisplay> displayMap = Maps.newHashMap();

    public static Pistorder getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return !TweakerMoreCompact.isTweakerMoreVersionEnabled();
    }

    public class_1269 onPlayerRightClickBlock(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.isEnabled()) {
            return class_1269.field_5814;
        }
        if (hand == class_1268.field_5808) {
            return this.onPlayerRightClickBlockWithMainHand(world, player, hit);
        }
        return class_1269.field_5814;
    }

    public class_1269 onPlayerRightClickBlockWithMainHand(class_1937 world, class_1657 player, class_3965 hit) {
        boolean extended;
        class_2338 pos;
        class_2680 blockState;
        class_2248 block;
        if (!this.isEnabled()) {
            return class_1269.field_5814;
        }
        if (player.method_6047().method_7960() && !player.method_5715() && (block = (blockState = world.method_8320(pos = hit.method_17777())).method_26204()) instanceof class_2665 && (!(extended = ((Boolean)blockState.method_11654((class_2769)class_2665.field_12191)).booleanValue()) || ((PistonBlockAccessor)block).getIsSticky())) {
            this.click(world, pos, blockState, (class_2350)blockState.method_11654((class_2769)class_2741.field_12525), extended ? PistonActionType.RETRACT : PistonActionType.PUSH);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private synchronized void click(class_1937 world, class_2338 pos, class_2680 blockState, class_2350 pistonFacing, PistonActionType PistonActionType2) {
        Pair key = Pair.of((Object)world, (Object)pos);
        PistorderDisplay display = this.displayMap.get(key);
        if (display == null) {
            this.displayMap.put((Pair<class_1937, class_2338>)key, new PistorderDisplay(world, pos, blockState, pistonFacing, PistonActionType2));
        } else {
            display.onClick();
            if (display.isDisabled()) {
                this.displayMap.remove(key);
            }
        }
    }

    public void render(class_4587 matrixStack, float tickDelta) {
        if (!this.isEnabled()) {
            this.displayMap.clear();
            return;
        }
        this.tickKeyBinding();
        ArrayList removeList = Lists.newArrayList();
        this.displayMap.forEach((key, display) -> {
            display.render(matrixStack, tickDelta);
            if (display.isDisabled()) {
                removeList.add(key);
            }
        });
        removeList.forEach(this.displayMap::remove);
    }

    private void tickKeyBinding() {
        if (PistorderKeyBinding.CLEAR_DISPLAY_KEY.method_1436()) {
            class_310.method_1551().field_1705.method_1758((class_2561)new class_2588("pistorder.clear_display.hint"), false);
            this.displayMap.clear();
        }
    }
}

