/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.geometry;

import java.util.ArrayList;
import java.util.Collection;
import org.leralix.tancommon.geometry.ChunkManager;
import org.leralix.tancommon.geometry.GenericHoleDetector;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tancommon.storage.TileFlags;

public class PolygonBuilder {
    private final int nbMaxIterations;

    public PolygonBuilder(int nbMaxIterations) {
        this.nbMaxIterations = nbMaxIterations;
    }

    public PolygonCoordinate buildPolygon(TileFlags ourShape, int minx, int minz) {
        int cur_x = minx;
        int cur_z = minz;
        ChunkManager.direction dir = ChunkManager.direction.XPLUS;
        ArrayList<int[]> linelist = new ArrayList<int[]>();
        linelist.add(new int[]{minx, minz});
        int nbIters = 0;
        while ((cur_x != minx || cur_z != minz || dir != ChunkManager.direction.ZMINUS) && nbIters < this.nbMaxIterations) {
            ++nbIters;
            switch (dir) {
                case XPLUS: {
                    if (!ourShape.getFlag(cur_x + 1, cur_z)) {
                        linelist.add(new int[]{cur_x + 1, cur_z});
                        dir = ChunkManager.direction.ZPLUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x + 1, cur_z - 1)) {
                        ++cur_x;
                        break;
                    }
                    linelist.add(new int[]{cur_x + 1, cur_z--});
                    dir = ChunkManager.direction.ZMINUS;
                    ++cur_x;
                    break;
                }
                case ZPLUS: {
                    if (!ourShape.getFlag(cur_x, cur_z + 1)) {
                        linelist.add(new int[]{cur_x + 1, cur_z + 1});
                        dir = ChunkManager.direction.XMINUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x + 1, cur_z + 1)) {
                        ++cur_z;
                        break;
                    }
                    linelist.add(new int[]{cur_x + 1, cur_z + 1});
                    dir = ChunkManager.direction.XPLUS;
                    ++cur_x;
                    ++cur_z;
                    break;
                }
                case XMINUS: {
                    if (!ourShape.getFlag(cur_x - 1, cur_z)) {
                        linelist.add(new int[]{cur_x, cur_z + 1});
                        dir = ChunkManager.direction.ZMINUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x - 1, cur_z + 1)) {
                        --cur_x;
                        break;
                    }
                    linelist.add(new int[]{cur_x--, cur_z + 1});
                    dir = ChunkManager.direction.ZPLUS;
                    ++cur_z;
                    break;
                }
                case ZMINUS: {
                    if (!ourShape.getFlag(cur_x, cur_z - 1)) {
                        linelist.add(new int[]{cur_x, cur_z});
                        dir = ChunkManager.direction.XPLUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x - 1, cur_z - 1)) {
                        --cur_z;
                        break;
                    }
                    linelist.add(new int[]{cur_x--, cur_z--});
                    dir = ChunkManager.direction.XMINUS;
                }
            }
        }
        int sz = linelist.size();
        int[] x = new int[sz];
        int[] z = new int[sz];
        for (int i = 0; i < sz; ++i) {
            int[] line = (int[])linelist.get(i);
            x[i] = line[0] * 16;
            z[i] = line[1] * 16;
        }
        return new PolygonCoordinate(x, z);
    }

    public Collection<PolygonCoordinate> getHoles(TileFlags ourShape, PolygonCoordinate computedShape) {
        ArrayList<PolygonCoordinate> holes = new ArrayList<PolygonCoordinate>();
        int minX = computedShape.getSmallestX() / 16;
        int minZ = computedShape.getSmallestZ() / 16;
        int maxX = computedShape.getBiggestX() / 16;
        int maxZ = computedShape.getBiggestZ() / 16;
        GenericHoleDetector genericHoleDetector = new GenericHoleDetector(ourShape);
        for (TileFlags tileFlags : genericHoleDetector.getHoles(minX, minZ, maxX, maxZ)) {
            int holeStartX = -1;
            int holeStartZ = -1;
            boolean found = false;
            for (int x = minX; x <= maxX && !found; ++x) {
                for (int z = minZ; z <= maxZ && !found; ++z) {
                    if (!tileFlags.getFlag(x, z) || tileFlags.getFlag(x + 1, z) && tileFlags.getFlag(x - 1, z) && tileFlags.getFlag(x, z + 1) && tileFlags.getFlag(x, z - 1)) continue;
                    holeStartX = x;
                    holeStartZ = z;
                    found = true;
                }
            }
            if (!found) continue;
            holes.add(this.buildPolygon(tileFlags, holeStartX, holeStartZ));
        }
        return holes;
    }
}

