/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.geometry;

import java.util.ArrayList;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tancommon.storage.TileFlags;

public class PolygonTracer {
    public final int nbIterationMax;

    public PolygonTracer(int nbIterationMax) {
        this.nbIterationMax = nbIterationMax;
    }

    public PolygonCoordinate trace(TileFlags shape, int minx, int minz) {
        int curX = minx;
        int curZ = minz;
        Direction dir = Direction.XPLUS;
        ArrayList<int[]> points = new ArrayList<int[]>();
        points.add(new int[]{minx, minz});
        int nbIters = 0;
        while ((curX != minx || curZ != minz || dir != Direction.ZMINUS) && nbIters < this.nbIterationMax) {
            ++nbIters;
            switch (dir.ordinal()) {
                case 0: {
                    if (!shape.getFlag(curX + 1, curZ)) {
                        points.add(new int[]{curX + 1, curZ});
                        dir = Direction.ZPLUS;
                        break;
                    }
                    if (!shape.getFlag(curX + 1, curZ - 1)) {
                        ++curX;
                        break;
                    }
                    points.add(new int[]{curX + 1, curZ--});
                    dir = Direction.ZMINUS;
                    ++curX;
                    break;
                }
                case 1: {
                    if (!shape.getFlag(curX, curZ + 1)) {
                        points.add(new int[]{curX + 1, curZ + 1});
                        dir = Direction.XMINUS;
                        break;
                    }
                    if (!shape.getFlag(curX + 1, curZ + 1)) {
                        ++curZ;
                        break;
                    }
                    points.add(new int[]{curX + 1, curZ + 1});
                    dir = Direction.XPLUS;
                    ++curX;
                    ++curZ;
                    break;
                }
                case 2: {
                    if (!shape.getFlag(curX - 1, curZ)) {
                        points.add(new int[]{curX, curZ + 1});
                        dir = Direction.ZMINUS;
                        break;
                    }
                    if (!shape.getFlag(curX - 1, curZ + 1)) {
                        --curX;
                        break;
                    }
                    points.add(new int[]{curX--, curZ + 1});
                    dir = Direction.ZPLUS;
                    ++curZ;
                    break;
                }
                case 3: {
                    if (!shape.getFlag(curX, curZ - 1)) {
                        points.add(new int[]{curX, curZ});
                        dir = Direction.XPLUS;
                        break;
                    }
                    if (!shape.getFlag(curX - 1, curZ - 1)) {
                        --curZ;
                        break;
                    }
                    points.add(new int[]{curX--, curZ--});
                    dir = Direction.XMINUS;
                }
            }
        }
        int sz = points.size();
        int[] x = new int[sz];
        int[] z = new int[sz];
        for (int i = 0; i < sz; ++i) {
            int[] p = (int[])points.get(i);
            x[i] = p[0] * 16;
            z[i] = p[1] * 16;
        }
        return new PolygonCoordinate(x, z);
    }

    private static enum Direction {
        XPLUS,
        ZPLUS,
        XMINUS,
        ZMINUS;

    }
}

