/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tansquaremap;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.position.Vector2D;
import org.leralix.lib.position.Vector3D;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.storage.Constants;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tancommon.storage.TanKey;
import org.tan.api.interfaces.TanFort;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanProperty;
import org.tan.api.interfaces.TanTerritory;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquaremapMarkerRegister
extends CommonMarkerRegister {
    private final Squaremap api = SquaremapProvider.get();
    private final Map<TanKey, SimpleLayerProvider> chunkLayerMap = new HashMap<TanKey, SimpleLayerProvider>();
    private final Map<TanKey, SimpleLayerProvider> landmarkLayerMap = new HashMap<TanKey, SimpleLayerProvider>();
    private final Map<TanKey, SimpleLayerProvider> fortLayerMap = new HashMap<TanKey, SimpleLayerProvider>();
    private final Map<TanKey, SimpleLayerProvider> propertiesLayerMap = new HashMap<TanKey, SimpleLayerProvider>();

    @Override
    protected void setupLandmarkLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.setupLayer(id, name, chunkLayerPriority, hideByDefault, worldsName, this.landmarkLayerMap);
    }

    @Override
    protected void setupChunkLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.setupLayer(id, name, chunkLayerPriority, hideByDefault, worldsName, this.chunkLayerMap);
    }

    @Override
    protected void setupFortLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.setupLayer(id, name, chunkLayerPriority, hideByDefault, worldsName, this.fortLayerMap);
    }

    @Override
    protected void setupPropertyLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.setupLayer(id, name, chunkLayerPriority, hideByDefault, worldsName, this.propertiesLayerMap);
    }

    private void setupLayer(String id, String name, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName, Map<TanKey, SimpleLayerProvider> landmarkLayerMap) {
        ArrayList<World> worlds = new ArrayList<World>();
        if (worldsName.contains("all") || worldsName.isEmpty()) {
            worlds.addAll(Bukkit.getWorlds());
        } else {
            for (String worldName : worldsName) {
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                worlds.add(world);
            }
        }
        for (World world : worlds) {
            TanKey key = new TanKey(world);
            SimpleLayerProvider layerProvider = SimpleLayerProvider.builder((String)name).layerPriority(chunkLayerPriority).defaultHidden(hideByDefault).build();
            landmarkLayerMap.put(key, layerProvider);
            Optional optionalWorld = this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world));
            if (!optionalWorld.isPresent()) continue;
            MapWorld mapWorld = (MapWorld)optionalWorld.get();
            mapWorld.layerRegistry().register(Key.of((String)id), (Object)layerProvider);
        }
    }

    @Override
    public boolean isWorking() {
        return this.api != null;
    }

    @Override
    public void registerNewLandmark(TanLandmark landmark) {
        Point point = Point.of((double)landmark.getLocation().getX(), (double)landmark.getLocation().getZ());
        MarkerOptions markerOptions = MarkerOptions.builder().hoverTooltip(this.generateDescription(landmark)).build();
        String imageKey = landmark.isOwned() ? IconType.LANDMARK_CLAIMED.getFileName() : IconType.LANDMARK_UNCLAIMED.getFileName();
        Marker marker = Marker.icon((Point)point, (Key)Key.of((String)imageKey), (int)16).markerOptions(markerOptions);
        TanKey key = new TanKey(landmark.getLocation().getWorld());
        this.landmarkLayerMap.get(key).addMarker(Key.of((String)landmark.getID()), marker);
    }

    @Override
    public void registerNewFort(TanFort fort) {
        Location location = fort.getFlagPosition().getLocation();
        Point point = Point.of((double)location.getX(), (double)location.getZ());
        MarkerOptions markerOptions = MarkerOptions.builder().hoverTooltip(this.generateDescription(fort)).build();
        String imageKey = IconType.FORT.getFileName();
        Marker marker = Marker.icon((Point)point, (Key)Key.of((String)imageKey), (int)16).markerOptions(markerOptions);
        TanKey key = new TanKey(location.getWorld());
        this.landmarkLayerMap.get(key).addMarker(Key.of((String)fort.getID()), marker);
    }

    @Override
    public void registerNewProperty(TanProperty tanProperty) {
        Vector3D point1 = tanProperty.getFirstCorner();
        Vector3D point2 = tanProperty.getSecondCorner();
        PolygonCoordinate boundaries = SquaremapMarkerRegister.getPolygonCoordinate(point1, point2);
        List<Point> pointList = SquaremapMarkerRegister.getPoints(boundaries);
        Color color = new Color(Constants.getPropertyColor(tanProperty));
        MarkerOptions options = MarkerOptions.builder().fillColor(color).fillOpacity(0.4).strokeColor(color).strokeOpacity(0.7).strokeWeight(2).hoverTooltip(this.generateDescription(tanProperty)).build();
        Marker marker = Marker.polygon(pointList).markerOptions(options);
        TanKey key = new TanKey(point1.getWorld());
        this.propertiesLayerMap.get(key).addMarker(Key.of((String)tanProperty.getID()), marker);
    }

    @Override
    public void registerNewArea(String polyid, TanTerritory territoryData, boolean b, String worldName, PolygonCoordinate coordinates, String infoWindowPopup, Collection<PolygonCoordinate> holes) {
        List<Point> pointList = SquaremapMarkerRegister.getPoints(coordinates);
        ArrayList<List<Point>> holesList = new ArrayList<List<Point>>();
        for (PolygonCoordinate hole : holes) {
            holesList.add(SquaremapMarkerRegister.getPoints(hole));
        }
        Color color = new Color(territoryData.getColor().asRGB());
        MarkerOptions options = MarkerOptions.builder().fillColor(color).fillOpacity(0.5).strokeColor(color).strokeOpacity(0.8).strokeWeight(2).hoverTooltip(infoWindowPopup).build();
        Marker marker = Marker.polygon(pointList, holesList).markerOptions(options);
        TanKey key = new TanKey(Bukkit.getWorld((String)worldName));
        this.chunkLayerMap.get(key).addMarker(Key.of((String)polyid), marker);
    }

    @NotNull
    private static List<Point> getPoints(PolygonCoordinate coordinates) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        double[] x = Arrays.stream(coordinates.getX()).asDoubleStream().toArray();
        double[] z = Arrays.stream(coordinates.getZ()).asDoubleStream().toArray();
        for (int i = 0; i < x.length; ++i) {
            pointList.add(Point.of((double)x[i], (double)z[i]));
        }
        return pointList;
    }

    @Override
    public void deleteAllMarkers() {
        for (SimpleLayerProvider layerProvider : this.chunkLayerMap.values()) {
            layerProvider.clearMarkers();
        }
        for (SimpleLayerProvider layerProvider : this.landmarkLayerMap.values()) {
            layerProvider.clearMarkers();
        }
        for (SimpleLayerProvider layerProvider : this.fortLayerMap.values()) {
            layerProvider.clearMarkers();
        }
        for (SimpleLayerProvider layerProvider : this.propertiesLayerMap.values()) {
            layerProvider.clearMarkers();
        }
    }

    @Override
    public void registerCapital(String townName, Vector2D capitalPosition) {
        Point point = Point.of((double)(capitalPosition.getX() * 16 + 8), (double)(capitalPosition.getZ() * 16 + 8));
        MarkerOptions markerOptions = MarkerOptions.builder().hoverTooltip(townName).build();
        String imageKey = IconType.CAPITAL.getFileName();
        Marker marker = Marker.icon((Point)point, (Key)Key.of((String)imageKey), (int)16).markerOptions(markerOptions);
        TanKey key = new TanKey(capitalPosition.getWorld());
        String formattedName = this.format(townName);
        this.fortLayerMap.get(key).addMarker(Key.of((String)formattedName), marker);
    }

    private String format(String value) {
        if (value == null) {
            return "Empty name";
        }
        return value.replaceAll("[^a-zA-Z0-9._-]", "");
    }

    @Override
    public void registerIcon(IconType iconType) {
        try {
            File file = new File(TownsAndNationsMapCommon.getPlugin().getDataFolder(), "icons/" + iconType.getFileName());
            BufferedImage image = ImageIO.read(file);
            Registry registry = SquaremapProvider.get().iconRegistry();
            if (registry.hasEntry(Key.of((String)iconType.getFileName()))) {
                registry.unregister(Key.of((String)iconType.getFileName()));
            }
            registry.register(Key.of((String)iconType.getFileName()), (Object)image);
        }
        catch (IOException e) {
            throw new RuntimeException("Erreur lors du chargement de landmark.png", e);
        }
    }
}

