/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.f3teverywhere.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import games.enchanted.f3teverywhere.Constants;
import games.enchanted.f3teverywhere.api.DebugKeysAnywhereCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyboardHandler.class})
public abstract class KeyboardHandlerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract boolean handleDebugKeys(int var1);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getWindow()Lcom/mojang/blaze3d/platform/Window;", ordinal=0)}, method={"keyPress"})
    private void f3teverywhere$handleDebugKeysInScreens(long windowPointer, int key, int scanCode, int action, int modifiers, CallbackInfo ci) {
        PauseScreen pause;
        Screen screen = this.minecraft.screen;
        if (screen instanceof DebugKeysAnywhereCompat) {
            int[] keysToSkip;
            DebugKeysAnywhereCompat debugKeysScreen = (DebugKeysAnywhereCompat)screen;
            if (debugKeysScreen.forceDisableDebugKeys()) {
                return;
            }
            for (int i : keysToSkip = debugKeysScreen.debugKeysToSkip()) {
                if (!InputConstants.isKeyDown((long)windowPointer, (int)i)) continue;
                return;
            }
        }
        if ((screen = this.minecraft.screen) instanceof PauseScreen && !(pause = (PauseScreen)screen).showsPauseMenu()) {
            return;
        }
        if (this.minecraft.screen instanceof GameModeSwitcherScreen) {
            return;
        }
        if (action != 0 && this.minecraft.screen != null) {
            if (!InputConstants.isKeyDown((long)windowPointer, (int)292)) {
                return;
            }
            try {
                this.handleDebugKeys(key);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"debugComponent(Lnet/minecraft/ChatFormatting;Lnet/minecraft/network/chat/Component;)V"})
    private void f3teverywhere$showDebugFeedbackToast(ChatFormatting formatting, Component message, CallbackInfo ci) {
        if (this.minecraft.level != null) {
            return;
        }
        SystemToast.addOrUpdate((ToastManager)this.minecraft.getToastManager(), (SystemToast.SystemToastId)Constants.DEBUG_FEEDBACK_TOAST, (Component)Component.translatable((String)"debug.prefix").withStyle(new ChatFormatting[]{formatting, ChatFormatting.BOLD}), (Component)message);
    }
}

