/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.atcplus.autotreechopplus.AutoTreeChopPlusAPI;
import org.atcplus.autotreechopplus.AutoTreeChopPlusExpansion;
import org.atcplus.autotreechopplus.Config;
import org.atcplus.autotreechopplus.Metrics;
import org.atcplus.autotreechopplus.PlayerConfig;
import org.atcplus.autotreechopplus.command.Command;
import org.atcplus.autotreechopplus.command.TabCompleter;
import org.atcplus.autotreechopplus.hooks.GriefPreventionHook;
import org.atcplus.autotreechopplus.hooks.LandsHook;
import org.atcplus.autotreechopplus.hooks.ResidenceHook;
import org.atcplus.autotreechopplus.hooks.WorldGuardHook;
import org.atcplus.autotreechopplus.libs.tinytranslations.BukkitTinyTranslations;
import org.atcplus.autotreechopplus.libs.tinytranslations.GlobalMessages;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageBuilder;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageTranslator;
import org.atcplus.autotreechopplus.libs.tinytranslations.TinyTranslations;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.properties.PropertiesMessageStorage;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.properties.PropertiesStyleStorage;
import org.atcplus.autotreechopplus.utils.CooldownManager;
import org.atcplus.autotreechopplus.utils.EffectUtils;
import org.atcplus.autotreechopplus.utils.PermissionUtils;
import org.atcplus.autotreechopplus.utils.TreeChopUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoTreeChopPlus
extends JavaPlugin
implements Listener,
CommandExecutor {
    public static final Message noResidencePermissions = new MessageBuilder("noResidencePermissions").withDefault("<prefix_negative>You don't have permission to use AutoTreeChopPlus here.</prefix_negative>").build();
    public static final Message ENABLED_MESSAGE = new MessageBuilder("enabled").withDefault("<prefix>Auto tree chopping enabled.</prefix>").build();
    public static final Message DISABLED_MESSAGE = new MessageBuilder("disabled").withDefault("<prefix_negative>Auto tree chopping disabled.</prefix_negative>").build();
    public static final Message NO_PERMISSION_MESSAGE = new MessageBuilder("no-permission").withDefault(GlobalMessages.NO_PERM_CMD).build();
    public static final Message ONLY_PLAYERS_MESSAGE = new MessageBuilder("only-players").withDefault(GlobalMessages.CMD_PLAYER_ONLY).build();
    public static final Message HIT_MAX_USAGE_MESSAGE = new MessageBuilder("hitmaxusage").withDefault("<prefix_negative>You've reached the daily usage limit.</prefix_negative>").build();
    public static final Message HIT_MAX_BLOCK_MESSAGE = new MessageBuilder("hitmaxblock").withDefault("<prefix_negative>You have reached your daily block breaking limit.</prefix_negative>").build();
    public static final Message USAGE_MESSAGE = new MessageBuilder("usage").withDefault("<prefix>You have used the AutoTreeChopPlus {current_uses}/{max_uses} times today.</prefix>").build();
    public static final Message BLOCKS_BROKEN_MESSAGE = new MessageBuilder("blocks-broken").withDefault("<prefix>You have broken {current_blocks}/{max_blocks} blocks today.</prefix>").build();
    public static final Message ENABLED_BY_OTHER_MESSAGE = new MessageBuilder("enabledByOther").withDefault("<prefix>Auto tree chopping enabled by {player}.</prefix>").build();
    public static final Message ENABLED_FOR_OTHER_MESSAGE = new MessageBuilder("enabledForOther").withDefault("<prefix>Auto tree chopping enabled for {player}</prefix>").build();
    public static final Message DISABLED_BY_OTHER_MESSAGE = new MessageBuilder("disabledByOther").withDefault("<prefix_negative>Auto tree chopping disabled by {player}.</prefix_negative>").build();
    public static final Message DISABLED_FOR_OTHER_MESSAGE = new MessageBuilder("disabledForOther").withDefault("<prefix_negative>Auto tree chopping disabled for {player}</prefix_negative>").build();
    public static final Message STILL_IN_COOLDOWN_MESSAGE = new MessageBuilder("stillInCooldown").withDefault("<prefix_negative>You are still in cooldown! Try again after {cooldown_time} seconds.</prefix_negative>").build();
    public static final Message CONSOLE_NAME = new MessageBuilder("consoleName").withDefault("console").build();
    public static final Message SNEAK_ENABLED_MESSAGE = new MessageBuilder("sneakEnabled").withDefault("<prefix>Auto tree chopping enabled by sneaking.</prefix>").build();
    public static final Message SNEAK_DISABLED_MESSAGE = new MessageBuilder("sneakDisabled").withDefault("<prefix_negative>Auto tree chopping disabled by stopping sneak.</prefix_negative>").build();
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.21.8", "1.21.7", "1.21.6", "1.21.5", "1.21.4", "1.21.3", "1.21.2", "1.21.1", "1.21", "1.20.6", "1.20.5", "1.20.4", "1.20.3", "1.20.2", "1.20.1", "1.20", "1.19.4", "1.19.3", "1.19.2", "1.19.1", "1.19", "1.18.2", "1.18.1", "1.18", "1.17.1", "1.17");
    private final Set<Location> checkedLocations = new HashSet<Location>();
    private final Set<Location> processingLocations = new HashSet<Location>();
    private Config config;
    private AutoTreeChopPlusAPI autoTreeChopPlusAPI;
    private Map<UUID, PlayerConfig> playerConfigs;
    private String bukkitVersion = this.getServer().getBukkitVersion();
    private Metrics metrics;
    private MessageTranslator translations;
    private boolean worldGuardEnabled = false;
    private boolean residenceEnabled = false;
    private boolean griefPreventionEnabled = false;
    private boolean landsEnabled = false;
    private WorldGuardHook worldGuardHook = null;
    private ResidenceHook residenceHook = null;
    private GriefPreventionHook griefPreventionHook = null;
    private LandsHook landsHook = null;
    private CooldownManager cooldownManager;
    private boolean enableSneakToggle = true;

    public static void sendMessage(CommandSender sender, ComponentLike message) {
        BukkitTinyTranslations.sendMessageIfNotEmpty(sender, message);
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new Config(this);
        if (this.bukkitVersion.length() > 14) {
            this.bukkitVersion = this.bukkitVersion.substring(0, this.bukkitVersion.length() - 14);
            if (!SUPPORTED_VERSIONS.contains(this.bukkitVersion)) {
                this.getLogger().warning("Your Minecraft version didn't fully tested yet.");
                this.getLogger().warning("IF you have any issues, feel free to report it at our GitHub: https://github.com/ATCPlus/AutoTreeChopPlus/issues");
            }
        }
        this.metrics = new Metrics((Plugin)this, 20053);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Command command = new Command(this);
        Objects.requireNonNull(this.getCommand("autotreechop")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("atc")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("autotreechop")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        Objects.requireNonNull(this.getCommand("atc")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.translations = BukkitTinyTranslations.application((Plugin)this);
        this.translations.setMessageStorage(new PropertiesMessageStorage(new File(this.getDataFolder(), "/lang/")));
        this.translations.setStyleStorage(new PropertiesStyleStorage(new File(this.getDataFolder(), "/lang/styles.properties")));
        this.translations.addMessages(TinyTranslations.messageFieldsFromClass(AutoTreeChopPlus.class));
        this.loadLocale();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new AutoTreeChopPlusExpansion(this).register();
            this.getLogger().info("PlaceholderAPI expansion for AutoTreeChopPlus has been registered.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder expansion for AutoTreeChopPlus will not work.");
        }
        this.autoTreeChopPlusAPI = new AutoTreeChopPlusAPI(this);
        this.playerConfigs = new HashMap<UUID, PlayerConfig>();
        this.initializeHooks();
        this.cooldownManager = new CooldownManager(this);
        this.enableSneakToggle = this.config.getSneakToggle();
    }

    private void initializeHooks() {
        if (Bukkit.getPluginManager().getPlugin("Residence") != null) {
            try {
                this.residenceHook = new ResidenceHook(this.config.getResidenceFlag());
                this.residenceEnabled = true;
                this.getLogger().info("Residence support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Residence can't be hook, please report this to our GitHub: https://github.com/ATCPlus/AutoTreeChopPlus/issues");
                this.residenceEnabled = false;
            }
        } else {
            this.residenceEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("GriefPrevention") != null) {
            try {
                this.griefPreventionHook = new GriefPreventionHook(this.config.getGriefPreventionFlag());
                this.griefPreventionEnabled = true;
                this.getLogger().info("GriefPrevention support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("GriefPrevention can't be hook, please report this to our GitHub: https://github.com/ATCPlus/AutoTreeChopPlus/issues");
                this.griefPreventionEnabled = false;
            }
        } else {
            this.griefPreventionEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("Lands") != null) {
            try {
                this.landsHook = new LandsHook((Plugin)this);
                this.landsEnabled = true;
                this.getLogger().info("Lands support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Lands can't be hook, please report this to our GitHub: https://github.com/ATCPlus/AutoTreeChopPlus/issues");
                this.landsEnabled = false;
            }
        } else {
            this.landsEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                this.worldGuardHook = new WorldGuardHook();
                this.getLogger().info("WorldGuard support enabled");
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warning("WorldGuard can't be hook, please report this to our GitHub: https://github.com/ATCPlus/AutoTreeChopPlus/issues");
                this.worldGuardEnabled = false;
            }
        } else {
            this.worldGuardEnabled = false;
        }
    }

    private void loadLocale() {
        this.saveResourceIfNotExists("lang/styles.properties");
        this.saveResourceIfNotExists("lang/de.properties");
        this.saveResourceIfNotExists("lang/es.properties");
        this.saveResourceIfNotExists("lang/fr.properties");
        this.saveResourceIfNotExists("lang/ja.properties");
        this.saveResourceIfNotExists("lang/ru.properties");
        this.saveResourceIfNotExists("lang/zh.properties");
        this.translations.setUseClientLocale(this.config.isUseClientLocale());
        this.translations.defaultLocale(this.config.getLocale() == null ? Locale.getDefault() : this.config.getLocale());
        this.translations.loadStyles();
        this.translations.loadLocales();
    }

    private void saveResourceIfNotExists(String resourcePath) {
        if (!new File(this.getDataFolder(), resourcePath).exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    public void onDisable() {
        this.translations.close();
        this.metrics.shutdown();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        PlayerConfig playerConfig = this.getPlayerConfig(playerUUID);
        Block block = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (this.processingLocations.contains(block.getLocation())) {
            return;
        }
        if (this.cooldownManager.isInCooldown(playerUUID)) {
            AutoTreeChopPlus.sendMessage((CommandSender)player, (ComponentLike)STILL_IN_COOLDOWN_MESSAGE.insertNumber("cooldown_time", this.cooldownManager.getRemainingCooldown(playerUUID)));
            event.setCancelled(true);
            return;
        }
        Material material = block.getType();
        Location location = block.getLocation();
        BlockData blockData = block.getBlockData();
        if (playerConfig.isAutoTreeChopPlusEnabled() && TreeChopUtils.isLog(material, this.config)) {
            if (!PermissionUtils.hasVipBlock(player, playerConfig, this.config) && playerConfig.getDailyBlocksBroken() >= this.config.getMaxBlocksPerDay()) {
                EffectUtils.sendMaxBlockLimitReachedMessage(player, block, HIT_MAX_BLOCK_MESSAGE);
                event.setCancelled(true);
                return;
            }
            if (!PermissionUtils.hasVipUses(player, playerConfig, this.config) && playerConfig.getDailyUses() >= this.config.getMaxUsesPerDay()) {
                BukkitTinyTranslations.sendMessage((CommandSender)player, HIT_MAX_USAGE_MESSAGE);
                return;
            }
            if (this.config.isVisualEffect()) {
                EffectUtils.showChopEffect(player, block);
            }
            event.setCancelled(true);
            this.checkedLocations.clear();
            TreeChopUtils.chopTree(block, player, this.config.isStopChoppingIfNotConnected(), tool, location, material, blockData, this, this.processingLocations, this.checkedLocations, this.config, playerConfig, this.worldGuardEnabled, this.residenceEnabled, this.griefPreventionEnabled, this.landsEnabled, this.landsHook, this.residenceHook, this.griefPreventionHook, this.worldGuardHook);
            this.checkedLocations.clear();
            playerConfig.incrementDailyUses();
            this.cooldownManager.setCooldown(player, playerUUID, this.config);
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.enableSneakToggle) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!player.hasPermission("atcplus.use")) {
            return;
        }
        PlayerConfig playerConfig = this.getPlayerConfig(playerUUID);
        if (event.isSneaking()) {
            playerConfig.setAutoTreeChopPlusEnabled(true);
            if (this.config.getSneakMessage()) {
                AutoTreeChopPlus.sendMessage((CommandSender)player, SNEAK_ENABLED_MESSAGE);
            }
        } else {
            playerConfig.setAutoTreeChopPlusEnabled(false);
            if (this.config.getSneakMessage()) {
                AutoTreeChopPlus.sendMessage((CommandSender)player, SNEAK_DISABLED_MESSAGE);
            }
        }
    }

    public PlayerConfig getPlayerConfig(UUID playerUUID) {
        PlayerConfig playerConfig = this.playerConfigs.get(playerUUID);
        if (playerConfig == null) {
            playerConfig = new PlayerConfig(this, playerUUID, this.config.isUseMysql(), this.config.getHostname(), this.config.getDatabase(), this.config.getPort(), this.config.getUsername(), this.config.getPassword(), this.config.getDefaultTreeChop());
            this.playerConfigs.put(playerUUID, playerConfig);
        }
        return playerConfig;
    }

    public int getPlayerDailyUses(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyUses();
    }

    public int getPlayerDailyBlocksBroken(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyBlocksBroken();
    }

    public AutoTreeChopPlusAPI getAutoTreeChopPlusAPI() {
        return this.autoTreeChopPlusAPI;
    }

    public Config getPluginConfig() {
        return this.config;
    }
}

