/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.atcplus.autotreechopplus.AutoTreeChopPlus;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final AutoTreeChopPlus plugin;
    private boolean visualEffect;
    private boolean toolDamage;
    private int maxUsesPerDay;
    private int maxBlocksPerDay;
    private int cooldownTime;
    private int vipCooldownTime;
    private boolean stopChoppingIfNotConnected;
    private boolean stopChoppingIfDifferentTypes;
    private boolean chopTreeAsync;
    private String residenceFlag;
    private String griefPreventionFlag;
    private Locale locale;
    private boolean useClientLocale;
    private boolean useMysql;
    private String hostname;
    private int port;
    private String database;
    private String username;
    private String password;
    private boolean limitVipUsage;
    private int vipUsesPerDay;
    private int vipBlocksPerDay;
    private int toolDamageDecrease;
    private boolean mustUseTool;
    private boolean defaultTreeChop;
    private boolean globalAlwaysOn;
    private boolean respectUnbreaking;
    private boolean playBreakSound;
    private Set<Material> logTypes;
    private boolean sneakToggle;
    private boolean commandToggle;
    private boolean sneakMessage;
    private boolean autoReplantEnabled;
    private long replantDelayTicks;
    private boolean requireSaplingInInventory;
    private boolean replantVisualEffect;
    private Map<Material, Material> logSaplingMapping;
    private Set<Material> validSoilTypes;
    private boolean leafRemovalEnabled;
    private long leafRemovalDelayTicks;
    private int leafRemovalRadius;
    private boolean leafRemovalDropItems;
    private boolean leafRemovalVisualEffects;
    private boolean leafRemovalAsync;
    private int leafRemovalBatchSize;
    private boolean leafRemovalCountsTowardsLimit;
    private boolean netherFungiEnabled;
    private String leafRemovalMode;
    private Set<Material> leafTypes;
    private static final EnumSet<Material> NETHER_FUNGI_LOGS = EnumSet.of(Material.CRIMSON_STEM, new Material[]{Material.STRIPPED_CRIMSON_STEM, Material.CRIMSON_HYPHAE, Material.STRIPPED_CRIMSON_HYPHAE, Material.WARPED_STEM, Material.STRIPPED_WARPED_STEM, Material.WARPED_HYPHAE, Material.STRIPPED_WARPED_HYPHAE});
    private static final EnumSet<Material> NETHER_FUNGI_LEAVES = EnumSet.of(Material.NETHER_WART_BLOCK, Material.WARPED_WART_BLOCK, Material.SHROOMLIGHT);
    private static final EnumSet<Material> NETHER_FUNGI_SOILS = EnumSet.of(Material.CRIMSON_NYLIUM, Material.WARPED_NYLIUM, Material.NETHERRACK);

    public Config(AutoTreeChopPlus plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        FileConfiguration defaultConfig = this.getDefaultConfig();
        if (!configFile.exists()) {
            try {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                configFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("An error occurred:" + String.valueOf(e));
                return;
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        for (String key : defaultConfig.getKeys(true)) {
            if (config.contains(key)) continue;
            config.set(key, defaultConfig.get(key));
        }
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("An error occurred while saving config: " + String.valueOf(e));
        }
        this.visualEffect = config.getBoolean("visual-effect");
        this.toolDamage = config.getBoolean("toolDamage");
        this.maxUsesPerDay = config.getInt("max-uses-per-day");
        this.maxBlocksPerDay = config.getInt("max-blocks-per-day");
        this.stopChoppingIfNotConnected = config.getBoolean("stopChoppingIfNotConnected");
        this.stopChoppingIfDifferentTypes = config.getBoolean("stopChoppingIfDifferentTypes");
        this.chopTreeAsync = config.getBoolean("chopTreeAsync");
        this.residenceFlag = config.getString("residenceFlag");
        this.griefPreventionFlag = config.getString("griefPreventionFlag");
        this.cooldownTime = config.getInt("cooldownTime");
        this.vipCooldownTime = config.getInt("vipCooldownTime");
        this.useClientLocale = config.getBoolean("use-player-locale");
        this.useMysql = config.getBoolean("useMysql");
        this.hostname = config.getString("hostname");
        this.port = config.getInt("port");
        this.database = config.getString("database");
        this.username = config.getString("username");
        this.password = config.getString("password");
        this.limitVipUsage = config.getBoolean("limitVipUsage");
        this.vipUsesPerDay = config.getInt("vip-uses-per-day");
        this.vipBlocksPerDay = config.getInt("vip-blocks-per-day");
        this.toolDamageDecrease = config.getInt("toolDamageDecrease");
        this.mustUseTool = config.getBoolean("mustUseTool");
        this.defaultTreeChop = config.getBoolean("defaultTreeChop");
        this.globalAlwaysOn = config.getBoolean("always-on-by-default", false);
        this.respectUnbreaking = config.getBoolean("respectUnbreaking");
        this.playBreakSound = config.getBoolean("playBreakSound");
        this.sneakToggle = config.getBoolean("enable-sneak-toggle");
        this.commandToggle = config.getBoolean("enable-command-toggle");
        this.sneakMessage = config.getBoolean("sneak-message");
        this.autoReplantEnabled = config.getBoolean("enable-auto-replant");
        this.replantDelayTicks = config.getLong("replant-delay-ticks");
        this.requireSaplingInInventory = config.getBoolean("require-sapling-in-inventory");
        this.replantVisualEffect = config.getBoolean("replant-visual-effect");
        this.netherFungiEnabled = config.getBoolean("enable-nether-fungi", true);
        this.leafRemovalEnabled = config.getBoolean("enable-leaf-removal");
        this.leafRemovalDelayTicks = config.getLong("leaf-removal-delay-ticks");
        this.leafRemovalRadius = config.getInt("leaf-removal-radius");
        this.leafRemovalDropItems = config.getBoolean("leaf-removal-drop-items");
        this.leafRemovalVisualEffects = config.getBoolean("leaf-removal-visual-effects");
        this.leafRemovalAsync = config.getBoolean("leaf-removal-async");
        this.leafRemovalBatchSize = config.getInt("leaf-removal-batch-size");
        this.leafRemovalCountsTowardsLimit = config.getBoolean("leaf-removal-counts-towards-limit");
        this.leafRemovalMode = config.getString("leaf-removal-mode", "smart");
        List leafTypeStrings = config.getStringList("leaf-types");
        this.leafTypes = leafTypeStrings.stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toSet());
        List soilTypeStrings = config.getStringList("valid-soil-types");
        this.validSoilTypes = soilTypeStrings.stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toSet());
        this.logSaplingMapping = new HashMap<Material, Material>();
        ConfigurationSection mappingSection = config.getConfigurationSection("log-sapling-mapping");
        if (mappingSection != null) {
            for (String logTypeStr : mappingSection.getKeys(false)) {
                Material logType = Material.getMaterial((String)logTypeStr);
                Material saplingType = Material.getMaterial((String)mappingSection.getString(logTypeStr));
                if (logType == null || saplingType == null || !this.netherFungiEnabled && NETHER_FUNGI_LOGS.contains(logType)) continue;
                this.logSaplingMapping.put(logType, saplingType);
            }
        }
        List logTypeStrings = config.getStringList("log-types");
        this.logTypes = logTypeStrings.stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toSet());
        Object localeObj = config.get("locale");
        if (localeObj instanceof String) {
            this.locale = Locale.forLanguageTag((String)localeObj);
        } else if (localeObj instanceof Locale) {
            this.locale = (Locale)localeObj;
        } else {
            this.locale = Locale.ENGLISH;
            this.plugin.getLogger().warning("Invalid locale setting in config.yml.  Using default: English");
        }
    }

    private FileConfiguration getDefaultConfig() {
        YamlConfiguration defaultConfig = new YamlConfiguration();
        defaultConfig.set("visual-effect", (Object)true);
        defaultConfig.set("toolDamage", (Object)true);
        defaultConfig.set("max-uses-per-day", (Object)50);
        defaultConfig.set("max-blocks-per-day", (Object)500);
        defaultConfig.set("cooldownTime", (Object)5);
        defaultConfig.set("vipCooldownTime", (Object)2);
        defaultConfig.set("stopChoppingIfNotConnected", (Object)false);
        defaultConfig.set("stopChoppingIfDifferentTypes", (Object)false);
        defaultConfig.set("chopTreeAsync", (Object)true);
        defaultConfig.set("use-player-locale", (Object)false);
        defaultConfig.set("useMysql", (Object)false);
        defaultConfig.set("hostname", (Object)"example.com");
        defaultConfig.set("port", (Object)3306);
        defaultConfig.set("database", (Object)"example");
        defaultConfig.set("username", (Object)"root");
        defaultConfig.set("password", (Object)"abc1234");
        defaultConfig.set("locale", (Object)Locale.ENGLISH.toString());
        defaultConfig.set("residenceFlag", (Object)"build");
        defaultConfig.set("griefPreventionFlag", (Object)"Build");
        defaultConfig.set("limitVipUsage", (Object)true);
        defaultConfig.set("vip-uses-per-day", (Object)50);
        defaultConfig.set("vip-blocks-per-day", (Object)500);
        defaultConfig.set("toolDamageDecrease", (Object)1);
        defaultConfig.set("mustUseTool", (Object)false);
        defaultConfig.set("defaultTreeChop", (Object)false);
        defaultConfig.set("always-on-by-default", (Object)false);
        defaultConfig.set("respectUnbreaking", (Object)true);
        defaultConfig.set("playBreakSound", (Object)true);
        defaultConfig.set("enable-sneak-toggle", (Object)false);
        defaultConfig.set("enable-command-toggle", (Object)true);
        defaultConfig.set("sneak-message", (Object)false);
        defaultConfig.set("enable-nether-fungi", (Object)true);
        defaultConfig.set("log-types", Arrays.asList("OAK_LOG", "SPRUCE_LOG", "BIRCH_LOG", "JUNGLE_LOG", "ACACIA_LOG", "DARK_OAK_LOG", "MANGROVE_LOG", "CHERRY_LOG", "PALE_OAK_LOG", "CRIMSON_STEM", "STRIPPED_CRIMSON_STEM", "CRIMSON_HYPHAE", "STRIPPED_CRIMSON_HYPHAE", "WARPED_STEM", "STRIPPED_WARPED_STEM", "WARPED_HYPHAE", "STRIPPED_WARPED_HYPHAE"));
        defaultConfig.set("enable-auto-replant", (Object)true);
        defaultConfig.set("replant-delay-ticks", (Object)20L);
        defaultConfig.set("require-sapling-in-inventory", (Object)false);
        defaultConfig.set("replant-visual-effect", (Object)true);
        defaultConfig.set("valid-soil-types", Arrays.asList("DIRT", "GRASS_BLOCK", "PODZOL", "COARSE_DIRT", "ROOTED_DIRT", "CRIMSON_NYLIUM", "WARPED_NYLIUM", "NETHERRACK"));
        ConfigurationSection logSaplingSection = defaultConfig.createSection("log-sapling-mapping");
        logSaplingSection.set("OAK_LOG", (Object)"OAK_SAPLING");
        logSaplingSection.set("BIRCH_LOG", (Object)"BIRCH_SAPLING");
        logSaplingSection.set("SPRUCE_LOG", (Object)"SPRUCE_SAPLING");
        logSaplingSection.set("JUNGLE_LOG", (Object)"JUNGLE_SAPLING");
        logSaplingSection.set("ACACIA_LOG", (Object)"ACACIA_SAPLING");
        logSaplingSection.set("DARK_OAK_LOG", (Object)"DARK_OAK_SAPLING");
        logSaplingSection.set("MANGROVE_LOG", (Object)"MANGROVE_PROPAGULE");
        logSaplingSection.set("CHERRY_LOG", (Object)"CHERRY_SAPLING");
        logSaplingSection.set("PALE_OAK_LOG", (Object)"PALE_OAK_SAPLING");
        logSaplingSection.set("CRIMSON_STEM", (Object)"CRIMSON_FUNGUS");
        logSaplingSection.set("STRIPPED_CRIMSON_STEM", (Object)"CRIMSON_FUNGUS");
        logSaplingSection.set("CRIMSON_HYPHAE", (Object)"CRIMSON_FUNGUS");
        logSaplingSection.set("STRIPPED_CRIMSON_HYPHAE", (Object)"CRIMSON_FUNGUS");
        logSaplingSection.set("WARPED_STEM", (Object)"WARPED_FUNGUS");
        logSaplingSection.set("STRIPPED_WARPED_STEM", (Object)"WARPED_FUNGUS");
        logSaplingSection.set("WARPED_HYPHAE", (Object)"WARPED_FUNGUS");
        logSaplingSection.set("STRIPPED_WARPED_HYPHAE", (Object)"WARPED_FUNGUS");
        defaultConfig.set("enable-leaf-removal", (Object)true);
        defaultConfig.set("leaf-removal-delay-ticks", (Object)40L);
        defaultConfig.set("leaf-removal-radius", (Object)8);
        defaultConfig.set("leaf-removal-drop-items", (Object)false);
        defaultConfig.set("leaf-removal-visual-effects", (Object)true);
        defaultConfig.set("leaf-removal-async", (Object)true);
        defaultConfig.set("leaf-removal-batch-size", (Object)20);
        defaultConfig.set("leaf-removal-counts-towards-limit", (Object)false);
        defaultConfig.set("leaf-types", Arrays.asList("OAK_LEAVES", "SPRUCE_LEAVES", "BIRCH_LEAVES", "JUNGLE_LEAVES", "ACACIA_LEAVES", "DARK_OAK_LEAVES", "MANGROVE_LEAVES", "CHERRY_LEAVES", "PALE_OAK_LEAVES", "NETHER_WART_BLOCK", "WARPED_WART_BLOCK", "SHROOMLIGHT"));
        defaultConfig.set("leaf-removal-mode", (Object)"smart");
        return defaultConfig;
    }

    public boolean isVisualEffect() {
        return this.visualEffect;
    }

    public boolean isToolDamage() {
        return this.toolDamage;
    }

    public int getMaxUsesPerDay() {
        return this.maxUsesPerDay;
    }

    public int getMaxBlocksPerDay() {
        return this.maxBlocksPerDay;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public int getVipCooldownTime() {
        return this.vipCooldownTime;
    }

    public boolean isStopChoppingIfNotConnected() {
        return this.stopChoppingIfNotConnected;
    }

    public boolean isStopChoppingIfDifferentTypes() {
        return this.stopChoppingIfDifferentTypes;
    }

    public boolean isChopTreeAsync() {
        return this.chopTreeAsync;
    }

    public String getResidenceFlag() {
        return this.residenceFlag;
    }

    public String getGriefPreventionFlag() {
        return this.griefPreventionFlag;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isUseClientLocale() {
        return this.useClientLocale;
    }

    public boolean isUseMysql() {
        return this.useMysql;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getLimitVipUsage() {
        return this.limitVipUsage;
    }

    public int getVipUsesPerDay() {
        return this.vipUsesPerDay;
    }

    public int getVipBlocksPerDay() {
        return this.vipBlocksPerDay;
    }

    public int getToolDamageDecrease() {
        return this.toolDamageDecrease;
    }

    public boolean getMustUseTool() {
        return this.mustUseTool;
    }

    public boolean getDefaultTreeChop() {
        return this.defaultTreeChop;
    }

    public boolean getRespectUnbreaking() {
        return this.respectUnbreaking;
    }

    public boolean getPlayBreakSound() {
        return this.playBreakSound;
    }

    public boolean getSneakToggle() {
        return this.sneakToggle;
    }

    public boolean getCommandToggle() {
        return this.commandToggle;
    }

    public boolean getSneakMessage() {
        return this.sneakMessage;
    }

    public Set<Material> getLogTypes() {
        return this.logTypes;
    }

    public boolean isAutoReplantEnabled() {
        return this.autoReplantEnabled;
    }

    public long getReplantDelayTicks() {
        return this.replantDelayTicks;
    }

    public boolean getRequireSaplingInInventory() {
        return this.requireSaplingInInventory;
    }

    public boolean getReplantVisualEffect() {
        return this.replantVisualEffect;
    }

    public Set<Material> getValidSoilTypes() {
        return this.validSoilTypes;
    }

    public Map<Material, Material> getLogSaplingMapping() {
        return this.logSaplingMapping;
    }

    public Material getSaplingForLog(Material logType) {
        return this.logSaplingMapping.get(logType);
    }

    public boolean isLeafRemovalEnabled() {
        return this.leafRemovalEnabled;
    }

    public long getLeafRemovalDelayTicks() {
        return this.leafRemovalDelayTicks;
    }

    public int getLeafRemovalRadius() {
        return this.leafRemovalRadius;
    }

    public boolean getLeafRemovalDropItems() {
        return this.leafRemovalDropItems;
    }

    public boolean getLeafRemovalVisualEffects() {
        return this.leafRemovalVisualEffects;
    }

    public boolean isLeafRemovalAsync() {
        return this.leafRemovalAsync;
    }

    public int getLeafRemovalBatchSize() {
        return this.leafRemovalBatchSize;
    }

    public boolean getLeafRemovalCountsTowardsLimit() {
        return this.leafRemovalCountsTowardsLimit;
    }

    public Set<Material> getLeafTypes() {
        return this.leafTypes;
    }

    public String getLeafRemovalMode() {
        return this.leafRemovalMode;
    }

    public boolean isNetherFungiEnabled() {
        return this.netherFungiEnabled;
    }
}

