/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.command;

import java.util.UUID;
import org.atcplus.autotreechopplus.AutoTreeChopPlus;
import org.atcplus.autotreechopplus.Config;
import org.atcplus.autotreechopplus.PlayerConfig;
import org.atcplus.autotreechopplus.libs.tinytranslations.BukkitTinyTranslations;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Command
implements CommandExecutor {
    private final AutoTreeChopPlus plugin;
    private final Config config;

    public Command(AutoTreeChopPlus plugin) {
        this.plugin = plugin;
        this.config = plugin.getPluginConfig();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, String[] args) {
        if (!(cmd.getName().equalsIgnoreCase("autotreechop") || cmd.getName().equalsIgnoreCase("atc") || cmd.getName().equalsIgnoreCase("autotreechopplus") || cmd.getName().equalsIgnoreCase("atcplus"))) {
            return false;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("atcplus.reload")) {
                this.config.load();
                sender.sendMessage("Config reloaded successfully.");
                sender.sendMessage("Some features might need a fully restart to change properly!");
            } else {
                AutoTreeChopPlus.sendMessage(sender, AutoTreeChopPlus.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("about")) {
            sender.sendMessage("AutoTreeChopPlus - " + this.plugin.getDescription().getVersion() + " is maintained by the ATCPlus team and community contributors");
            sender.sendMessage("This JAR and the source code is licensed under the GNU General Public License v3.0 (GPL-3.0)");
            sender.sendMessage("GitHub: https://github.com/ATCPlus/AutoTreeChopPlus");
            sender.sendMessage("Discord: https://discord.gg/uQ4UXANnP2");
            sender.sendMessage("Modrinth: https://modrinth.com/plugin/autotreechopplus");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("enable-all")) {
            if (sender.hasPermission("atcplus.other") || sender.hasPermission("atcplus.op")) {
                this.toggleAutoTreeChopForAll(sender, true);
                AutoTreeChopPlus.sendMessage(sender, (ComponentLike)AutoTreeChopPlus.ENABLED_FOR_OTHER_MESSAGE.insertString("player", "everyone"));
            } else {
                AutoTreeChopPlus.sendMessage(sender, AutoTreeChopPlus.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("disable-all")) {
            if (sender.hasPermission("atcplus.other") || sender.hasPermission("atcplus.op")) {
                this.toggleAutoTreeChopForAll(sender, false);
                AutoTreeChopPlus.sendMessage(sender, (ComponentLike)AutoTreeChopPlus.DISABLED_FOR_OTHER_MESSAGE.insertString("player", "everyone"));
            } else {
                AutoTreeChopPlus.sendMessage(sender, AutoTreeChopPlus.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            if (args.length > 0) {
                this.handleTargetPlayerToggle(sender, args[0]);
            } else {
                AutoTreeChopPlus.sendMessage(sender, AutoTreeChopPlus.ONLY_PLAYERS_MESSAGE);
            }
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("atcplus.use")) {
            AutoTreeChopPlus.sendMessage((CommandSender)player, AutoTreeChopPlus.NO_PERMISSION_MESSAGE);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("usage")) {
            this.handleUsageCommand(player);
            return true;
        }
        if (args.length > 0) {
            this.handleTargetPlayerToggle((CommandSender)player, args[0]);
            return true;
        }
        if (!this.config.getCommandToggle()) {
            AutoTreeChopPlus.sendMessage((CommandSender)player, AutoTreeChopPlus.NO_PERMISSION_MESSAGE);
            return true;
        }
        this.toggleAutoTreeChopPlus(player, player.getUniqueId());
        return true;
    }

    private void handleUsageCommand(Player player) {
        if (!player.hasPermission("atcplus.vip")) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertNumber("max_uses", this.config.getMaxUsesPerDay()));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertNumber("max_blocks", this.config.getMaxBlocksPerDay()));
        } else if (player.hasPermission("atcplus.vip") && this.config.getLimitVipUsage()) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertNumber("max_uses", this.config.getVipUsesPerDay()));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertNumber("max_blocks", this.config.getVipBlocksPerDay()));
        } else if (player.hasPermission("atcplus.vip") && !this.config.getLimitVipUsage()) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertString("max_uses", "\u221e"));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChopPlus.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertString("max_blocks", "\u221e"));
        }
    }

    private void handleTargetPlayerToggle(CommandSender sender, String targetPlayerName) {
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            sender.sendMessage("Player not found: " + targetPlayerName);
            return;
        }
        UUID targetUUID = targetPlayer.getUniqueId();
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(targetUUID);
        boolean autoTreeChopPlusEnabled = !playerConfig.isAutoTreeChopPlusEnabled();
        playerConfig.setAutoTreeChopPlusEnabled(autoTreeChopPlusEnabled);
        if (autoTreeChopPlusEnabled) {
            AutoTreeChopPlus.sendMessage(sender, (ComponentLike)AutoTreeChopPlus.ENABLED_FOR_OTHER_MESSAGE.insertString("player", targetPlayer.getName()));
            AutoTreeChopPlus.sendMessage((CommandSender)targetPlayer, (ComponentLike)AutoTreeChopPlus.ENABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()));
        } else {
            AutoTreeChopPlus.sendMessage(sender, (ComponentLike)AutoTreeChopPlus.DISABLED_FOR_OTHER_MESSAGE.insertString("player", targetPlayer.getName()));
            AutoTreeChopPlus.sendMessage((CommandSender)targetPlayer, (ComponentLike)AutoTreeChopPlus.DISABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()));
        }
    }

    private void toggleAutoTreeChopPlus(Player player, UUID playerUUID) {
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
        boolean autoTreeChopPlusEnabled = !playerConfig.isAutoTreeChopPlusEnabled();
        playerConfig.setAutoTreeChopPlusEnabled(autoTreeChopPlusEnabled);
        if (autoTreeChopPlusEnabled) {
            BukkitTinyTranslations.sendMessage((CommandSender)player, AutoTreeChopPlus.ENABLED_MESSAGE);
        } else {
            BukkitTinyTranslations.sendMessage((CommandSender)player, AutoTreeChopPlus.DISABLED_MESSAGE);
        }
    }

    private void toggleAutoTreeChopForAll(CommandSender sender, boolean autoTreeChopPlusEnabled) {
        Message message = autoTreeChopPlusEnabled ? (Message)AutoTreeChopPlus.ENABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()) : (Message)AutoTreeChopPlus.DISABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName());
        Bukkit.getOnlinePlayers().parallelStream().forEach(onlinePlayer -> {
            UUID playerUUID = onlinePlayer.getUniqueId();
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
            playerConfig.setAutoTreeChopPlusEnabled(autoTreeChopPlusEnabled);
            AutoTreeChopPlus.sendMessage((CommandSender)onlinePlayer, message);
        });
    }
}

