/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageEncoding;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageTranslator;
import org.atcplus.autotreechopplus.libs.tinytranslations.TinyTranslations;
import org.atcplus.autotreechopplus.libs.tinytranslations.UnownedMessage;
import org.atcplus.autotreechopplus.libs.tinytranslations.UnownedMessageImpl;
import org.atcplus.autotreechopplus.libs.tinytranslations.annotation.KeyPattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class MessageBuilder {
    private final String key;
    private final Map<Locale, String> translations;
    private final List<String> comments;
    private final Collection<Message.PlaceholderDescription> placeholderDescriptions;
    private final Collection<TagResolver> defaultResolvers;

    public MessageBuilder(@KeyPattern String key) {
        this.key = key;
        this.comments = new ArrayList<String>();
        this.translations = new HashMap<Locale, String>();
        this.placeholderDescriptions = new LinkedList<Message.PlaceholderDescription>();
        this.defaultResolvers = new LinkedList<TagResolver>();
    }

    public MessageBuilder withComment(String line) {
        this.comments.add(line);
        return this;
    }

    public MessageBuilder withDefault(@Language(value="NanoMessage") String defaultValue) {
        this.translations.put(TinyTranslations.FALLBACK_DEFAULT_LOCALE, defaultValue);
        return this;
    }

    public MessageBuilder withDefault(Message otherToEmbed) {
        this.translations.put(TinyTranslations.FALLBACK_DEFAULT_LOCALE, "{msg:" + otherToEmbed.key() + "}");
        return this;
    }

    public MessageBuilder withTranslation(Locale locale, @Language(value="NanoMessage") String translation) {
        return this.withTranslation(locale, MessageEncoding.MINI_MESSAGE, translation);
    }

    public MessageBuilder withTranslation(Locale locale, MessageEncoding format, String translation) {
        this.translations.put(locale, format.wrap(translation));
        return this;
    }

    public MessageBuilder withPlaceholders(String ... placeholders) {
        for (String placeholder : placeholders) {
            this.withPlaceholder(placeholder, (String)null);
        }
        return this;
    }

    public MessageBuilder withPlaceholder(String tag) {
        return this.withPlaceholder(tag, (String)null);
    }

    public MessageBuilder withPlaceholder(String tag, String description) {
        this.placeholderDescriptions.add(new Message.PlaceholderDescription(new String[]{tag}, description, null));
        return this;
    }

    public MessageBuilder withPlaceholder(String tag, Class<?> type) {
        return this.withPlaceholder(tag, null, type);
    }

    public MessageBuilder withPlaceholder(String tag, String description, Class<?> type) {
        this.placeholderDescriptions.add(new Message.PlaceholderDescription(new String[]{tag}, description, type));
        return this;
    }

    public MessageBuilder withPlaceholder(String tag, String description, @NotNull TagResolver defaultResolver) {
        this.defaultResolvers.add(defaultResolver);
        return this.withPlaceholder(tag, description);
    }

    public Message build(MessageTranslator owner) {
        Message message;
        Message msg = this.build();
        if (msg instanceof UnownedMessage) {
            UnownedMessage unowned = (UnownedMessage)msg;
            message = unowned.owner(owner);
        } else {
            message = msg;
        }
        return message;
    }

    public Message build() {
        return (Message)new UnownedMessageImpl(this.key).comment(this.comments.isEmpty() ? null : String.join((CharSequence)"\n", this.comments)).dictionary(this.translations).placeholderDescriptions(this.placeholderDescriptions).formatted((TagResolver[])this.defaultResolvers.toArray(TagResolver[]::new));
    }
}

