/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.AdventureTranslatorAdapter;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageReferenceLoopException;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageStyle;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageTranslator;

public class MessageReferenceLoopDetector {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\\{msg(:[a-zA-Z0-9-_.]+){1,2}}");
    private static final Pattern STYLE_PATTERN = Pattern.compile("<([!#]?[a-zA-Z0-9-_.]+)>");

    private MessageTranslator findOwner(Message message) {
        for (MessageTranslator source : AdventureTranslatorAdapter.instance().getTranslators()) {
            if (source.getMessage(message.getKey()) == null) continue;
            return source;
        }
        return null;
    }

    public Collection<MessageReferenceLoopException> detectLoops(Message message) {
        LinkedList<MessageReferenceLoopException> exceptions = new LinkedList<MessageReferenceLoopException>();
        message.dictionary().forEach((locale, s) -> {
            MessageReferenceLoopException e = this.detectLoops(message, (Locale)locale);
            if (e != null) {
                exceptions.add(e);
            }
        });
        return exceptions;
    }

    public MessageReferenceLoopException detectLoops(Message message, Locale locale) {
        try {
            this.buildTree(message, new Stack<String>(), message, locale);
        }
        catch (MessageReferenceLoopException e) {
            return e;
        }
        catch (Throwable t) {
            return new MessageReferenceLoopException(t);
        }
        return null;
    }

    private Node buildTree(Message origin, Stack<String> stack, Message msg, Locale locale) {
        stack.push("(msg:" + locale.toLanguageTag() + ") " + msg.key());
        String s = msg.dictionary().get(locale);
        if (s == null) {
            return new Node(null, new HashSet<Node>());
        }
        MessageTranslator translator = this.findOwner(origin);
        if (translator == null) {
            throw new IllegalStateException("Could not find translator for message '" + msg.getKey() + "'.");
        }
        return this.buildTree(origin, stack, locale, translator, s);
    }

    private Node buildTree(Message origin, Stack<String> stack, MessageStyle style, MessageTranslator messageTranslator, Locale locale) {
        stack.push("(style) " + messageTranslator.getPath() + ":" + style.getKey());
        String s = style.asString();
        return this.buildTree(origin, stack, locale, messageTranslator, s);
    }

    private Node buildTree(Message origin, Stack<String> stack, Locale locale, MessageTranslator t, String msg) {
        HashSet<Node> references = new HashSet<Node>();
        Matcher styleMatcher = STYLE_PATTERN.matcher(msg);
        while (styleMatcher.find()) {
            MessageStyle style;
            String key = styleMatcher.group(1);
            if (stack.contains("(style) " + key)) {
                throw new MessageReferenceLoopException(origin, stack);
            }
            if (key.contains(":")) {
                String[] seg = key.split(":");
                style = t.getStyleByNamespace(seg[0], seg[1]);
            } else {
                style = t.getStyleInParentTree(key);
            }
            if (style == null) continue;
            Stack<String> stackCopy = new Stack<String>();
            stackCopy.addAll(stack);
            references.add(this.buildTree(origin, stackCopy, style, t, locale));
        }
        Matcher msgMatcher = MESSAGE_PATTERN.matcher(msg);
        while (msgMatcher.find()) {
            Message ref;
            String key = msgMatcher.group(1).substring(1);
            if (key.contains(":")) {
                String[] seg = key.split(":");
                ref = t.getMessageByNamespace(seg[0], seg[1]);
            } else {
                ref = t.getMessageInParentTree(key);
            }
            if (ref == null) continue;
            if (stack.contains("(msg:" + locale.toLanguageTag() + ") " + ref.translationKey())) {
                throw new MessageReferenceLoopException(origin, stack);
            }
            Stack<String> stackCopy = new Stack<String>();
            stackCopy.addAll(stack);
            references.add(this.buildTree(origin, stackCopy, ref, locale));
        }
        return new Node(msg, references);
    }

    private record Node(String id, Collection<Node> references) {
    }
}

