/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageStyle;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.Context;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.ParsingException;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.Commented;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageStyleImpl
implements MessageStyle,
Commented<MessageStyleImpl> {
    private final String key;
    private final String representation;
    private final TagResolver resolver;
    private final String comment;

    public MessageStyleImpl(String key, String representation) {
        this(key, representation, null);
    }

    public MessageStyleImpl(String key, String representation, String comment) {
        this.key = key;
        if (!((String)representation).contains("{slot}")) {
            representation = (String)representation + "{slot}";
        }
        this.representation = representation;
        this.comment = comment;
        this.resolver = TagResolver.resolver(key, (ArgumentQueue argumentQueue, Context ctx) -> (c, depth) -> {
            if (depth > 0) {
                return Component.empty();
            }
            Matcher matcher = Pattern.compile("\\{arg([0-9]+)}").matcher(this.representation);
            int highest = -1;
            while (matcher.find()) {
                int x = Integer.parseInt(matcher.group(1));
                if (x <= highest) continue;
                highest = x;
            }
            ArrayList<TagResolver.Single> r = new ArrayList<TagResolver.Single>();
            int i = 0;
            while (i <= highest && argumentQueue.hasNext()) {
                r.add(Placeholder.component("arg" + i++, ctx.deserialize(argumentQueue.pop().value())));
            }
            r.add(Placeholder.component("slot", c));
            return ctx.deserialize(this.representation, (TagResolver[])r.toArray(TagResolver[]::new));
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageStyleImpl that = (MessageStyleImpl)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public String namespace() {
        return null;
    }

    @Override
    @NotNull
    public String value() {
        return this.representation;
    }

    @Override
    @NotNull
    public String asString() {
        return this.representation;
    }

    public String toString() {
        return this.representation;
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        return this.resolver.resolve(name, arguments, ctx);
    }

    @Override
    public boolean has(@NotNull String name) {
        return this.key.equalsIgnoreCase(name);
    }

    @Override
    @Nullable
    public String comment() {
        return this.comment;
    }

    @Override
    public MessageStyleImpl comment(@Nullable String comment) {
        return new MessageStyleImpl(this.key, this.representation, comment);
    }
}

