/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atcplus.autotreechopplus.libs.tinytranslations.AdventureTranslatorAdapter;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageBuilder;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageImpl;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageReferenceLoopDetector;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageReferenceLoopException;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageStyle;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageTranslator;
import org.atcplus.autotreechopplus.libs.tinytranslations.StyleSet;
import org.atcplus.autotreechopplus.libs.tinytranslations.TinyTranslations;
import org.atcplus.autotreechopplus.libs.tinytranslations.TranslationKey;
import org.atcplus.autotreechopplus.libs.tinytranslations.UnownedMessage;
import org.atcplus.autotreechopplus.libs.tinytranslations.annotation.AppPathPattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.annotation.AppPattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.annotation.KeyPattern;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.key.Key;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.TextComponent;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.TranslatableComponent;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.event.HoverEventSource;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.translation.GlobalTranslator;
import org.atcplus.autotreechopplus.libs.tinytranslations.libs.kyori.adventure.util.TriState;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.tag.MessageTag;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.tag.ObjectNotationTag;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.tag.StyleTag;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.MessageStorage;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.StorageEntry;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.StyleStorage;
import org.atcplus.autotreechopplus.libs.tinytranslations.tinyobject.InsertedObject;
import org.atcplus.autotreechopplus.libs.tinytranslations.tinyobject.TinyObjectMapping;
import org.atcplus.autotreechopplus.libs.tinytranslations.util.MessageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageTranslatorImpl
implements MessageTranslator {
    private final MessageTranslator parent;
    @AppPattern
    private final String name;
    private final Map<String, MessageTranslator> children;
    private final Map<TranslationKey, Message> messageSet;
    private final StyleSet styleSet;
    private final Collection<TagResolver> resolvers = new LinkedList<TagResolver>();
    private final Collection<TinyObjectMapping> objectResolvers = new LinkedList<TinyObjectMapping>();
    @Nullable
    private MessageStorage messageStorage;
    @Nullable
    private StyleStorage styleStorage;
    private boolean useClientLocale = true;
    @NotNull
    private Locale defaultLocale = Locale.ENGLISH;
    private final Map<String, InsertedObject> insertedObjects = new HashMap<String, InsertedObject>();
    private Logger logger = Logger.getLogger("TinyTranslations");

    public MessageTranslatorImpl(MessageTranslator parent, String name) {
        this.parent = parent;
        this.name = name.toLowerCase();
        this.children = new ConcurrentHashMap<String, MessageTranslator>();
        this.messageStorage = null;
        this.styleStorage = null;
        this.messageSet = new HashMap<TranslationKey, Message>();
        this.styleSet = new StyleSet();
        this.logger = Logger.getLogger("TinyTranslations:" + this.getPath());
        AdventureTranslatorAdapter.instance().register(this);
    }

    @Override
    @AppPathPattern
    public String getPath() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getPath() + "." + this.name;
    }

    @Override
    public void close() {
        AdventureTranslatorAdapter.instance().unregister(this);
        new HashMap<String, MessageTranslator>(this.children).forEach((s, translations) -> translations.close());
        if (this.parent != null) {
            this.parent.remove(this.name);
        }
    }

    @Override
    public void remove(String application) {
        MessageTranslator c = this.children.remove(application);
        if (c != null) {
            c.close();
        }
    }

    @Override
    public MessageTranslator fork(String name) {
        if (this.children.containsKey(name)) {
            throw new IllegalArgumentException("Another fork with name '" + name + "' already exists.");
        }
        MessageTranslatorImpl child = new MessageTranslatorImpl(this, name);
        this.children.put(name, child);
        child.addAll(this.objectResolvers);
        return child;
    }

    @Override
    public Message message(String key) {
        MessageImpl message = new MessageImpl(TranslationKey.of(this.getPath(), key));
        this.messageSet.put(message.getKey(), message);
        return message;
    }

    @Override
    public MessageBuilder messageBuilder(final String key) {
        return new MessageBuilder(key){

            @Override
            public Message build() {
                Message msg = super.build();
                MessageTranslatorImpl.this.addMessage(msg);
                return MessageTranslatorImpl.this.getMessage(TranslationKey.of(MessageTranslatorImpl.this.getPath(), key));
            }
        };
    }

    @Override
    public Component translate(Message message, TagResolver ... resolvers) {
        return this.translate((TranslatableComponent)message.formatted(resolvers), this.defaultLocale());
    }

    @Override
    public Component translate(Message message, Locale locale, TagResolver ... resolvers) {
        return this.translate((TranslatableComponent)message.formatted(resolvers), locale);
    }

    @Override
    public Component translate(String raw, TagResolver ... resolvers) {
        return this.translate(raw, this.defaultLocale(), resolvers);
    }

    @Override
    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        Object obj;
        TagResolver resolver;
        String key = component.key();
        TinyTranslations.getLogger().finest("Translating message with key '" + key + "'.");
        Message message = this.getMessageInParentTree(key);
        if (message == null) {
            if (component.key().endsWith("__anonymous__") && component instanceof Message) {
                Message temp;
                message = temp = (Message)component;
            } else {
                return null;
            }
        }
        Locale l = this.useClientLocale ? locale : this.defaultLocale;
        HashMap<String, InsertedObject> objectMap = new HashMap<String, InsertedObject>(this.insertedObjects);
        if (component instanceof Message) {
            Message formatted = (Message)component;
            if (formatted instanceof UnownedMessage) {
                UnownedMessage unowned = (UnownedMessage)formatted;
                formatted = unowned.owner(this);
            }
            objectMap.putAll(formatted.insertedObjects());
            resolver = TagResolver.builder().resolvers(this.getResolvers()).resolvers(formatted.getResolvers()).resolver(ObjectNotationTag.resolver(objectMap, this.getTinyObjectResolvers())).build();
        } else {
            resolver = TagResolver.builder().resolvers(this.getResolvers()).resolver(ObjectNotationTag.resolver(this.insertedObjects, this.getTinyObjectResolvers())).build();
        }
        Component translation = this.translate(MessageUtil.getMessageTranslation(message, l), l, resolver);
        if (translation == null) {
            return null;
        }
        if (!translation.children().isEmpty()) {
            translation = translation.children(translation.children().stream().map(c -> {
                if (c instanceof Message) {
                    Message m = (Message)c;
                    m.insertedObjects().putAll(objectMap);
                    return (Component)m.formatted(resolver);
                }
                return c;
            }).map(c -> GlobalTranslator.renderer().render(c instanceof UnownedMessage ? ((UnownedMessage)c).owner(this) : c, l)).toList());
        }
        for (Component child : component.children()) {
            translation = translation.append(child);
        }
        if (component.hoverEvent() != null && (obj = component.hoverEvent().value()) instanceof Component) {
            Component c2 = (Component)obj;
            component = (TranslatableComponent)component.hoverEvent((HoverEventSource)GlobalTranslator.renderer().render(c2, locale));
        }
        translation = ((TextComponent)((TextComponent)Component.empty().style(component.style())).append(translation)).compact();
        return translation;
    }

    @Override
    public Component translate(String raw, Locale locale, TagResolver ... resolvers) {
        if (raw == null) {
            return null;
        }
        TinyTranslations.getLogger().finest("Formatting value: '" + raw + "'.");
        LinkedList<TagResolver> r = new LinkedList<TagResolver>(this.resolvers);
        r.addAll(List.of(resolvers));
        MessageTranslator t = this;
        while (t.getParent() != null) {
            t = t.getParent();
            r.addAll(t.getResolvers());
        }
        r.add(MessageTag.resolver(this));
        r.add(StyleTag.resolver(this));
        Component component = TinyTranslations.NM.deserialize(raw, TagResolver.resolver(r));
        if (component == null) {
            return null;
        }
        if (component instanceof Message) {
            Message msg = (Message)component;
            component = this.translate((TranslatableComponent)msg, locale);
        }
        return component;
    }

    @Override
    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        return null;
    }

    @Override
    @NotNull
    public TriState hasAnyTranslations() {
        return TriState.TRUE;
    }

    @Override
    @Nullable
    public Message getMessage(String key) {
        String path = this.getPath();
        if (key.startsWith(path)) {
            return this.messageSet.get(TranslationKey.of(path, key.substring(path.length() + 1)));
        }
        return this.messageSet.get(TranslationKey.of(path, key));
    }

    @Override
    @Nullable
    public Message getMessage(TranslationKey key) {
        return this.messageSet.get(key);
    }

    @Override
    @Nullable
    public MessageStyle getStyle(String key) {
        return (MessageStyle)this.styleSet.get(key);
    }

    @Override
    @Nullable
    public MessageStyle getStyleInParentTree(String key) {
        MessageStyle style = this.getStyle(key);
        if (style != null) {
            return style;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getStyleInParentTree(key);
    }

    @Override
    @Nullable
    public Message getMessageInParentTree(String key) {
        Message msg = this.getMessage(key);
        if (msg != null) {
            return msg;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getMessageInParentTree(key);
    }

    @Nullable
    private MessageTranslator getTranslationsByNamespace(@AppPathPattern String namespace) {
        MessageTranslator messageTranslator = this;
        String[] split = namespace.split("\\.");
        LinkedList<String> path = new LinkedList<String>(List.of(split));
        path.poll();
        while (!path.isEmpty()) {
            String childName = (String)path.poll();
            messageTranslator = this.children.get(childName);
            if (messageTranslator != null) continue;
            return null;
        }
        return messageTranslator;
    }

    @Override
    @Nullable
    public Message getMessageByNamespace(@AppPathPattern String namespace, String key) {
        if (this.parent != null) {
            return this.parent.getMessageByNamespace(namespace, key);
        }
        MessageTranslator messageTranslator = this.getTranslationsByNamespace(namespace);
        return messageTranslator == null ? null : messageTranslator.getMessageInParentTree(key);
    }

    @Override
    @Nullable
    public MessageStyle getStyleByNamespace(@AppPathPattern String namespace, String key) {
        if (this.parent != null) {
            return this.parent.getStyleByNamespace(namespace, key);
        }
        MessageTranslator messageTranslator = this.getTranslationsByNamespace(namespace);
        return messageTranslator == null ? null : messageTranslator.getStyleInParentTree(key);
    }

    @Override
    public void addMessage(@NotNull Message message) {
        if (!(message instanceof UnownedMessage)) {
            throw new IllegalArgumentException("The provided message already belongs to a translator. Messages can only belong to one translator.");
        }
        UnownedMessage unowned = (UnownedMessage)message;
        message = unowned.owner(this);
        this.messageSet.put(message.getKey(), message);
    }

    @Override
    public void addMessages(Message ... messages) {
        for (Message message : messages) {
            if (message == null) continue;
            this.addMessage(message);
        }
    }

    @Override
    public void addMessage(Iterable<Message> messages) {
        for (Message message : messages) {
            this.addMessage(message);
        }
    }

    @Override
    public Collection<TinyObjectMapping> getTinyObjectResolvers() {
        LinkedList<TinyObjectMapping> result = new LinkedList<TinyObjectMapping>(this.objectResolvers);
        if (this.parent != null) {
            result.addAll(this.parent.getTinyObjectResolvers());
        }
        return result;
    }

    @Override
    public void addAll(Iterable<TinyObjectMapping> resolvers) {
        resolvers.forEach(this.objectResolvers::add);
    }

    @Override
    public void add(TinyObjectMapping resolver) {
        this.objectResolvers.add(resolver);
    }

    @Override
    public void remove(TinyObjectMapping resolver) {
        this.objectResolvers.remove(resolver);
    }

    @Override
    public void loadStyles() {
        try {
            if (this.parent != null) {
                this.parent.loadStyles();
            }
            if (this.styleStorage != null) {
                this.styleSet.putAll(this.styleStorage.loadStyles());
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, t.getMessage());
        }
    }

    @Override
    public void saveStyles() {
        if (this.styleStorage != null) {
            this.styleStorage.writeStyles(this.styleSet);
        }
    }

    @Override
    public void loadLocales() {
        if (this.parent != null) {
            this.parent.loadLocales();
        }
        if (this.messageStorage != null) {
            for (Locale availableLocale : this.messageStorage.fetchLocales()) {
                this.loadLocale(availableLocale, false);
            }
        }
    }

    @Override
    public void loadLocale(Locale locale) {
        this.loadLocale(locale, true);
    }

    private void loadLocale(Locale locale, boolean parentCall) {
        if (parentCall && this.parent != null) {
            this.parent.loadLocale(locale);
        }
        if (this.messageStorage != null) {
            HashMap<String, StorageEntry> keys = new HashMap<String, StorageEntry>();
            this.messageStorage.readMessages(locale).forEach((translationKey, s) -> {
                if (this.messageSet.containsKey(translationKey)) {
                    Message msg = this.messageSet.get(translationKey);
                    this.messageSet.put(msg.getKey(), (Message)msg.dictionaryEntry(locale, s.value()).comment(s.comment()));
                } else {
                    keys.put(translationKey.key(), (StorageEntry)s);
                }
            });
            keys.forEach((k, v) -> this.messageBuilder((String)k).withTranslation(locale, v.value()).withComment(v.comment()).build());
        }
        MessageReferenceLoopDetector loopDetector = new MessageReferenceLoopDetector();
        LinkedList loops = new LinkedList();
        this.messageSet.values().forEach(message -> {
            MessageReferenceLoopException loop = loopDetector.detectLoops((Message)message, locale);
            if (loop == null) {
                return;
            }
            HashMap<Locale, String> dict = new HashMap<Locale, String>(message.dictionary());
            dict.remove(locale);
            loops.add(message.dictionary(dict));
            this.logger.severe(loop.getMessage());
        });
        loops.forEach(msg -> this.messageSet.put(msg.getKey(), (Message)msg));
    }

    @Override
    public void saveLocale(Locale locale) {
        if (this.messageStorage != null) {
            this.messageStorage.writeMessages(this.messageSet.values(), locale);
        }
    }

    @Override
    public void saveMessagesAndBackupExistingValues(Collection<Message> messages, Locale locale) {
        if (this.messageStorage == null) {
            return;
        }
        Map<TranslationKey, StorageEntry> loadedValues = this.messageStorage.readMessages(locale);
        ArrayList<Message> list = new ArrayList<Message>();
        for (Message message : messages) {
            Message stored = this.getMessage(message.getKey());
            if (stored == null) continue;
            String oldVal = loadedValues.get(message.getKey()).value();
            String newVal = message.dictionary().get(locale);
            if (Objects.equals(newVal, oldVal)) continue;
            String comment = "Backed up value: '" + oldVal + "'";
            stored = stored.comment() == null || stored.comment().isEmpty() ? (Message)stored.comment(comment) : (Message)stored.comment(stored.comment() + "\n" + comment);
            list.add(stored);
        }
        this.messageStorage.overwriteMessages(list, locale);
        this.loadLocales();
    }

    @Override
    public void saveMessagesIfOldValueEquals(Map<Message, String> messages, Locale locale) {
        if (this.messageStorage == null) {
            return;
        }
        Map<TranslationKey, StorageEntry> loadedValues = this.messageStorage.readMessages(locale);
        LinkedList<Message> toOverride = new LinkedList<Message>();
        for (Map.Entry<Message, String> e : messages.entrySet()) {
            String presentStr;
            StorageEntry present = loadedValues.get(e.getKey().getKey());
            if (present == null || (presentStr = present.value()) == null || !presentStr.equals(e.getValue())) continue;
            toOverride.add(e.getKey());
        }
        this.messageStorage.overwriteMessages(toOverride, locale);
    }

    @Override
    public MessageTranslator formatted(TagResolver ... resolver) {
        this.resolvers.addAll(List.of(resolver));
        return this;
    }

    @Override
    public Map<String, InsertedObject> insertedObjects() {
        return this.insertedObjects;
    }

    @Override
    public <T> MessageTranslator insertObject(@NotNull String key, T obj, Collection<TinyObjectMapping> resolvers) {
        this.insertedObjects.put(key, new InsertedObject(key, obj, resolvers));
        return this;
    }

    @Override
    @NotNull
    public Key name() {
        return Key.key(this.getPath(), this.getName());
    }

    @Override
    public boolean contains(@NotNull String key) {
        if (this.messageSet.containsKey(key)) {
            return true;
        }
        String path = this.getPath();
        if (key.length() < path.length() + 1) {
            return false;
        }
        String namespace = (key = key.substring(path.length() + 1)).substring(path.length());
        if (!namespace.equalsIgnoreCase(path)) {
            return false;
        }
        return this.messageSet.containsKey(key);
    }

    @Override
    public void register(@KeyPattern @NotNull String key, @NotNull Locale locale, @NotNull MessageFormat format) {
        Map<Locale, String> dict = Map.of(locale, format.toPattern());
        this.messageSet.getOrDefault(TranslationKey.of(key), this.message(key).dictionary(dict));
    }

    @Override
    public void unregister(@KeyPattern @NotNull String key) {
        this.messageSet.remove(TranslationKey.of(key));
    }

    public String toString() {
        return "MessageTranslator[path=" + this.getPath() + "]";
    }

    @Override
    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public void defaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Override
    public MessageTranslator getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<TranslationKey, Message> getMessageSet() {
        return this.messageSet;
    }

    @Override
    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    @Override
    public Collection<TagResolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    @Nullable
    public MessageStorage getMessageStorage() {
        return this.messageStorage;
    }

    @Override
    public void setMessageStorage(@Nullable MessageStorage messageStorage) {
        this.messageStorage = messageStorage;
    }

    @Override
    @Nullable
    public StyleStorage getStyleStorage() {
        return this.styleStorage;
    }

    @Override
    public void setStyleStorage(@Nullable StyleStorage styleStorage) {
        this.styleStorage = styleStorage;
    }

    @Override
    public boolean isUseClientLocale() {
        return this.useClientLocale;
    }

    @Override
    public void setUseClientLocale(boolean useClientLocale) {
        this.useClientLocale = useClientLocale;
    }
}

