/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler;

import java.util.Objects;
import java.util.stream.Collectors;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.NanoMessageParser;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.CompilationStep;
import org.atcplus.autotreechopplus.libs.tinytranslations.util.compiler.SimpleStringParser;

public class ContentTagCompilation
implements CompilationStep {
    @Override
    public boolean apply(SimpleStringParser.Node node, CompilationStep.Context context) {
        SimpleStringParser.Node content;
        if (!Objects.equals(node.getType(), "CONTENT_TAG")) {
            return false;
        }
        SimpleStringParser.Node open = node.getChildren().get(0);
        String openKey = open.getChildren().get(0).getText();
        Object attributes = open.getChildren().get(1).getChildren().stream().map(Object::toString).map(s -> ":" + s).collect(Collectors.joining());
        if (node.getChildren().size() > 1 && !((String)(content = node.getChildren().get(1)).getType()).equals("CLOSE_TAG")) {
            if (NanoMessageParser.PRE.stream().anyMatch(s -> s.equalsIgnoreCase(openKey))) {
                attributes = (String)attributes + ":'" + content + "'/";
                content.replace("");
                if (node.getChildren().size() == 3) {
                    node.getChildren().get(2).replace("");
                }
            } else {
                context.parse(content);
            }
        }
        open.replace("<" + openKey + (String)attributes + ">");
        return true;
    }
}

