/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler;

import java.util.List;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.NanoMessageParser;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.NanoMessageTokenizer;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.ChoiceCompilation;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.CompilationStep;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.ContentTagCompilation;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.ObjectTagCompilation;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.PlaceholderCompilation;
import org.atcplus.autotreechopplus.libs.tinytranslations.nanomessage.compiler.SelfClosingTagCompilation;
import org.atcplus.autotreechopplus.libs.tinytranslations.util.compiler.SimpleStringParser;
import org.intellij.lang.annotations.Language;

public class NanoMessageCompiler {
    private final List<CompilationStep> compilationSteps = List.of(new ObjectTagCompilation(), new SelfClosingTagCompilation(), new PlaceholderCompilation(), new ChoiceCompilation(), new ContentTagCompilation(), (node, context) -> {
        node.getChildren().forEach(context::parse);
        return true;
    });

    public String compile(@Language(value="NanoMessage") String value) {
        NanoMessageTokenizer tokenizer = new NanoMessageTokenizer();
        List<NanoMessageTokenizer.TokenValue> tokens = tokenizer.tokenize(value);
        NanoMessageParser parser = new NanoMessageParser(tokens);
        SimpleStringParser.Node root = this.compile(parser.parse());
        return root.getText();
    }

    private SimpleStringParser.Node compile(SimpleStringParser.Node node) {
        for (CompilationStep compilationStep : this.compilationSteps) {
            if (compilationStep.apply(node, this::compile)) break;
        }
        return node;
    }
}

