/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations.storage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.atcplus.autotreechopplus.libs.tinytranslations.Message;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.MessageStorage;
import org.jetbrains.annotations.Nullable;

public abstract class FileMessageStorage
implements MessageStorage {
    final File directory;
    final String filePrefix;
    final String fileSuffix;

    public FileMessageStorage(File directory, String prefix, String suffix) {
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Language directory must not be a file.");
        }
        this.directory = directory;
        this.filePrefix = prefix;
        this.fileSuffix = suffix;
    }

    void mkDir() {
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
    }

    @Override
    public Collection<Message> writeMessages(Collection<Message> messages, Locale locale) {
        return this.writeMessages(messages, locale, false);
    }

    @Override
    public Collection<Message> overwriteMessages(Collection<Message> messages, Locale locale) {
        return this.writeMessages(messages, locale, true);
    }

    protected abstract Collection<Message> writeMessages(Collection<Message> var1, Locale var2, boolean var3);

    @Override
    public Collection<Locale> fetchLocales() {
        if (this.directory == null || !this.directory.exists()) {
            return Collections.emptyList();
        }
        File[] files = this.directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).filter(name -> name.matches(this.filePrefix + ".+" + this.fileSuffix)).map(s -> s.substring(this.filePrefix.length(), s.length() - this.fileSuffix.length())).map(Locale::forLanguageTag).toList();
    }

    @Nullable
    protected File localeFileIfExists(Locale locale) {
        File file = new File(this.directory, this.filePrefix + locale.toLanguageTag() + this.fileSuffix);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    protected File localeFile(Locale locale) {
        this.mkDir();
        File file = new File(this.directory, this.filePrefix + locale.toLanguageTag() + this.fileSuffix);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    public Charset detectCharset(File f, Charset[] charsets) {
        for (Charset charset : charsets) {
            Charset result = this.detectCharset(f, charset);
            if (result == null) continue;
            return result;
        }
        return StandardCharsets.UTF_8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Charset detectCharset(File f, Charset charset) {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));){
            CharsetDecoder decoder = charset.newDecoder();
            decoder.reset();
            byte[] buffer = new byte[512];
            boolean identified = false;
            while (input.read(buffer) != -1 && !identified) {
                identified = this.identify(buffer, decoder);
            }
            input.close();
            if (identified) {
                Charset charset2 = charset;
                return charset2;
            }
            Charset charset3 = null;
            return charset3;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }
}

